/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.util.InventoryUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class SmeltObjective
extends TypedObjective {
    public SmeltObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(InventoryClickEvent.class, this::handle, EventPriority.MONITOR);
    }

    public void handle(InventoryClickEvent event) {
        InventoryType inventoryType = event.getInventory().getType();
        if (event.getWhoClicked() == this.data.profile().getPlayer() && SmeltObjective.isSmeltingResultExtraction(event, inventoryType)) {
            int taken = SmeltObjective.calculateTakeAmount(event);
            ItemStack item = event.getCurrentItem();
            TypeId id = AuroraAPI.getItemManager().resolveId(item);
            this.progress(taken, this.meta(id));
        }
    }

    private static boolean isSmeltingResultExtraction(InventoryClickEvent event, InventoryType inventoryType) {
        return (inventoryType == InventoryType.FURNACE || inventoryType == InventoryType.SMOKER || inventoryType == InventoryType.BLAST_FURNACE) && event.getWhoClicked() instanceof Player && event.getRawSlot() == 2 && !InventoryUtils.isEmptySlot(event.getCurrentItem());
    }

    private static int calculateTakeAmount(InventoryClickEvent event) {
        ItemStack result = event.getCurrentItem();
        PlayerInventory inventory = event.getWhoClicked().getInventory();
        switch (event.getClick()) {
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: {
                return Math.min(InventoryUtils.calculateSpaceForItem((Inventory)inventory, result), result.getAmount());
            }
            case CONTROL_DROP: {
                return InventoryUtils.calculateSpaceForItem((Inventory)inventory, result);
            }
            case NUMBER_KEY: {
                return InventoryUtils.calculateSwapCraftAmount(result, inventory.getItem(event.getHotbarButton()));
            }
            case SWAP_OFFHAND: {
                return InventoryUtils.calculateSwapCraftAmount(result, inventory.getItemInOffHand());
            }
            case DROP: {
                return 1;
            }
            case RIGHT: {
                if (InventoryUtils.isEmptySlot(event.getCursor())) {
                    return (result.getAmount() + 1) / 2;
                }
            }
            case LEFT: {
                return InventoryUtils.calculateSimpleCraftAmount(result, event.getCursor());
            }
        }
        return 0;
    }
}

