/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.event.objective.PlayerTakeItemEvent;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;

public class TakeItemObjective
extends TypedObjective {
    public TakeItemObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(PlayerTakeItemEvent.class, this::handle, EventPriority.MONITOR);
    }

    public void handle(PlayerTakeItemEvent event) {
        if (event.getQuest() != this.quest) {
            return;
        }
        ConfigurationSection args = this.definition.getArgs();
        Player player = this.data.profile().getPlayer();
        String itemId = args.getString("item");
        int currentAmount = (int)this.data.getProgress();
        int requiredAmount = args.getInt("amount", 1);
        int remainingAmount = requiredAmount - currentAmount;
        if (itemId == null || remainingAmount <= 0) {
            return;
        }
        TypeId typeId = TypeId.fromString((String)itemId);
        try {
            int amountNeeded = remainingAmount;
            for (ItemStack invItem : player.getInventory().getContents()) {
                if (invItem == null || !AuroraAPI.getItemManager().resolveId(invItem).equals((Object)typeId)) continue;
                int amount = invItem.getAmount();
                if (amount > amountNeeded) {
                    invItem.setAmount(amount - amountNeeded);
                    amountNeeded = 0;
                    break;
                }
                amountNeeded -= amount;
                invItem.setAmount(0);
            }
            if (remainingAmount - amountNeeded <= 0) {
                return;
            }
            this.setProgress(currentAmount + (remainingAmount - amountNeeded));
        }
        catch (Exception e) {
            AuroraQuests.logger().severe("Failed to take items");
            e.printStackTrace();
        }
    }
}

