/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.quests.api.objective.Objective;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Statistic;

public class TravelObjective
extends Objective {
    private final List<StatHandler> handlers = new ArrayList<StatHandler>();
    private static final Map<String, Statistic> stats = Map.of("walk", Statistic.WALK_ONE_CM, "sprint", Statistic.SPRINT_ONE_CM, "swim", Statistic.SWIM_ONE_CM, "boat", Statistic.BOAT_ONE_CM, "horse", Statistic.HORSE_ONE_CM, "pig", Statistic.PIG_ONE_CM, "strider", Statistic.STRIDER_ONE_CM, "walk-on-water", Statistic.WALK_ON_WATER_ONE_CM, "walk-under-water", Statistic.WALK_UNDER_WATER_ONE_CM);

    public TravelObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
        boolean all = definition.getArgs().getBoolean("all", false);
        for (Map.Entry<String, Statistic> stat : stats.entrySet()) {
            if (!definition.getArgs().getBoolean(stat.getKey(), false) && !all) continue;
            this.handlers.add(new StatHandler(stat.getValue()));
        }
    }

    @Override
    protected void activate() {
        for (StatHandler handler : this.handlers) {
            handler.activate(this.data);
        }
        this.syncInterval(this::handler, 100, 100, false);
    }

    private void handler() {
        double sum = 0.0;
        for (StatHandler handler : this.handlers) {
            sum += handler.handle(this.data);
        }
        if (sum > 0.0) {
            this.progress(sum, this.meta());
        }
    }

    public static final class StatHandler {
        private final Statistic stat;
        private int previousValue;

        public void activate(Profile.TaskDataWrapper data) {
            this.previousValue = data.profile().getPlayer().getStatistic(this.stat);
        }

        public double handle(Profile.TaskDataWrapper data) {
            int current = data.profile().getPlayer().getStatistic(this.stat);
            int diff = current - this.previousValue;
            if (diff > 0) {
                this.previousValue = current;
                return (double)diff / 100.0;
            }
            return 0.0;
        }

        public StatHandler(Statistic stat) {
            this.stat = stat;
        }
    }
}

