/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.parser;

import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardFactory;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.quest.QuestDefinition;
import gg.auroramc.quests.api.quest.QuestRequirement;
import gg.auroramc.quests.config.quest.QuestConfig;
import gg.auroramc.quests.config.quest.StartRequirementConfig;
import gg.auroramc.quests.config.quest.TaskConfig;
import gg.auroramc.quests.parser.ObjectiveParser;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;

public class QuestParser {
    public static QuestDefinition parse(QuestConfig config, RewardFactory rewardFactory) {
        return QuestDefinition.builder().id(config.getId()).name(config.getName()).difficulty(config.getDifficulty()).requirements(QuestParser.parseRequirement(config.getStartRequirements())).rewards(QuestParser.parseRewards(config.getRewards(), rewardFactory)).tasks(QuestParser.parseTasks(config.getTasks())).menuItem(config.getMenuItem()).completedLore(config.getCompletedLore()).lockedLore(config.getLockedLore()).uncompletedLore(config.getUncompletedLore()).questCompleteMessage(config.getQuestCompleteMessage()).questCompleteSound(config.getQuestCompleteSound()).build();
    }

    public static QuestRequirement parseRequirement(StartRequirementConfig config) {
        if (config == null) {
            return new QuestRequirement(false, false, null, null);
        }
        return new QuestRequirement(config.isAlwaysShowInMenu(), config.isNeedsManualUnlock(), config.getQuests(), config.getPermissions());
    }

    public static LinkedHashMap<String, Reward> parseRewards(ConfigurationSection config, RewardFactory factory) {
        if (config == null) {
            return new LinkedHashMap<String, Reward>();
        }
        LinkedHashMap<String, Reward> rewards = new LinkedHashMap<String, Reward>();
        for (String key : config.getKeys(false)) {
            Optional reward = factory.createReward(config.getConfigurationSection(key));
            reward.ifPresent(value -> rewards.put(key, (Reward)value));
        }
        return rewards;
    }

    private static LinkedHashMap<String, ObjectiveDefinition> parseTasks(Map<String, TaskConfig> map) {
        LinkedHashMap<String, ObjectiveDefinition> tasks = new LinkedHashMap<String, ObjectiveDefinition>();
        for (String key : map.keySet()) {
            tasks.put(key, ObjectiveParser.parse(key, map.get(key)));
        }
        return tasks;
    }
}

