/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.placeholder;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.questpool.PoolManager;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.util.DurationFormatter;
import gg.auroramc.quests.util.RomanNumber;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class QuestPlaceholderHandler
implements PlaceholderHandler {
    public String getIdentifier() {
        return "quests";
    }

    public String onPlaceholderRequest(Player player, String[] args) {
        if (args.length < 2) {
            return null;
        }
        Profile profile = AuroraQuests.getInstance().getProfileManager().getProfile(player);
        if (profile == null) {
            return "";
        }
        String full = String.join((CharSequence)"_", args);
        if (full.endsWith("total_completed_raw")) {
            long sum = profile.getQuestPools().stream().mapToLong(QuestPool::getCompletedQuestCount).sum();
            return String.valueOf(sum);
        }
        if (full.endsWith("total_completed")) {
            long sum = profile.getQuestPools().stream().mapToLong(QuestPool::getCompletedQuestCount).sum();
            return AuroraAPI.formatNumber((long)sum);
        }
        if (full.endsWith("level_roman")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 12));
            if (pool == null) {
                return null;
            }
            return RomanNumber.toRoman(pool.getLevel());
        }
        if (full.endsWith("level_raw")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 10));
            if (pool == null) {
                return null;
            }
            return String.valueOf(pool.getLevel());
        }
        if (full.endsWith("level")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 6));
            if (pool == null) {
                return null;
            }
            return AuroraAPI.formatNumber((long)pool.getLevel());
        }
        if (full.endsWith("current_count")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 14));
            if (pool == null) {
                return null;
            }
            return AuroraAPI.formatNumber((long)pool.getActiveQuests().size());
        }
        if (full.endsWith("current_completed")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 18));
            if (pool == null) {
                return null;
            }
            return AuroraAPI.formatNumber((long)pool.getActiveQuests().stream().filter(Quest::isCompleted).count());
        }
        if (full.endsWith("count_raw")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 10));
            if (pool == null) {
                return null;
            }
            return String.valueOf(pool.getCompletedQuestCount());
        }
        if (full.endsWith("count")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 6));
            if (pool == null) {
                return null;
            }
            return AuroraAPI.formatNumber((long)pool.getCompletedQuestCount());
        }
        if (full.endsWith("countdown_long")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 15));
            if (pool == null) {
                return null;
            }
            if (pool.isGlobal()) {
                return null;
            }
            return DurationFormatter.format((CommandSender)player, pool.getDurationUntilNextRoll(), DurationFormatter.Type.LONG);
        }
        if (full.endsWith("countdown")) {
            QuestPool pool = profile.getQuestPool(full.substring(0, full.length() - 10));
            if (pool == null) {
                return null;
            }
            if (pool.isGlobal()) {
                return null;
            }
            return DurationFormatter.format((CommandSender)player, pool.getDurationUntilNextRoll(), DurationFormatter.Type.SHORT);
        }
        return null;
    }

    public List<String> getPatterns() {
        PoolManager manager = AuroraQuests.getInstance().getPoolManager();
        ArrayList<String> list = new ArrayList<String>(manager.getPoolIds().size() * 7 + 2);
        list.add("total_completed_raw");
        list.add("total_completed");
        for (String pool : manager.getPoolIds()) {
            list.add(pool + "_level");
            list.add(pool + "_level_roman%");
            list.add(pool + "_level_raw");
            list.add(pool + "_count");
            list.add(pool + "_count_raw");
            list.add(pool + "_current_count");
            list.add(pool + "_current_completed");
            list.add(pool + "_countdown");
            list.add(pool + "_countdown_long");
        }
        return list;
    }
}

