/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.util;

import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.config.MessageConfig;
import java.time.Duration;
import org.bukkit.command.CommandSender;

public class DurationFormatter {
    private static final long SECONDS_IN_A_MINUTE = 60L;
    private static final long SECONDS_IN_AN_HOUR = 3600L;
    private static final long SECONDS_IN_A_DAY = 86400L;
    private static final long SECONDS_IN_A_WEEK = 604800L;

    public static String format(CommandSender sender, Duration duration, Type type) {
        MessageConfig.TimerFormatConfig config = AuroraQuests.getInstance().getConfigManager().getMessageConfig(sender).getTimerFormat();
        MessageConfig.DurationFormatConfig format = type == Type.LONG ? config.getLongFormat() : config.getShortFormat();
        long seconds = duration.getSeconds();
        long weeks = seconds / 604800L;
        long days = (seconds %= 604800L) / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        StringBuilder result = new StringBuilder();
        if (weeks > 0L) {
            if (weeks > 1L) {
                result.append(format.getPlural().getWeeks().replace("{value}", "" + weeks));
            } else {
                result.append(format.getSingular().getWeeks().replace("{value}", "" + weeks));
            }
        }
        if (days > 0L) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            if (days > 1L) {
                result.append(format.getPlural().getDays().replace("{value}", "" + days));
            } else {
                result.append(format.getSingular().getDays().replace("{value}", "" + days));
            }
        }
        if (hours > 0L) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            if (hours > 1L) {
                result.append(format.getPlural().getHours().replace("{value}", "" + hours));
            } else {
                result.append(format.getSingular().getHours().replace("{value}", "" + hours));
            }
        }
        if (minutes > 0L) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            if (minutes > 1L) {
                result.append(format.getPlural().getMinutes().replace("{value}", "" + minutes));
            } else {
                result.append(format.getSingular().getMinutes().replace("{value}", "" + minutes));
            }
        }
        if (seconds > 0L || result.isEmpty()) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            if (seconds > 1L) {
                result.append(format.getPlural().getSeconds().replace("{value}", "" + seconds));
            } else {
                result.append(format.getSingular().getSeconds().replace("{value}", "" + seconds));
            }
        }
        return result.toString();
    }

    public static enum Type {
        LONG,
        SHORT;

    }
}

