/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.util;

import java.util.Arrays;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class InventoryUtils {
    private InventoryUtils() {
    }

    public static boolean isEmptySlot(@Nullable ItemStack slotItem) {
        return slotItem == null || slotItem.getType().equals((Object)Material.AIR);
    }

    public static int calculateSpaceForItem(Inventory inventory, ItemStack item) {
        int remainingSpace = 0;
        for (ItemStack i : inventory.getStorageContents()) {
            if (InventoryUtils.isEmptySlot(i)) {
                remainingSpace += item.getMaxStackSize();
                continue;
            }
            if (!i.isSimilar(item)) continue;
            remainingSpace += item.getMaxStackSize() - i.getAmount();
        }
        return remainingSpace;
    }

    public static int calculateMaximumCraftActions(ItemStack ... ingredients) {
        return Arrays.stream(ingredients).filter(((Predicate<ItemStack>)InventoryUtils::isEmptySlot).negate()).mapToInt(ItemStack::getAmount).min().orElse(Integer.MAX_VALUE);
    }

    public static int calculateShiftCraftAmount(ItemStack result, Inventory inventory, ItemStack ... ingredients) {
        int remainingSpace = InventoryUtils.calculateSpaceForItem(inventory, result);
        int itemsPerCraft = result.getAmount();
        int spaceForCrafts = remainingSpace / itemsPerCraft;
        return Math.min(InventoryUtils.calculateMaximumCraftActions(ingredients), spaceForCrafts) * itemsPerCraft;
    }

    public static int calculateMaximumCraftAmount(ItemStack result, ItemStack ... ingredients) {
        return InventoryUtils.calculateMaximumCraftActions(ingredients) * result.getAmount();
    }

    public static int calculateSwapCraftAmount(ItemStack result, @Nullable ItemStack swapped) {
        return InventoryUtils.isEmptySlot(swapped) ? result.getAmount() : 0;
    }

    public static int calculateSimpleCraftAmount(ItemStack result, @Nullable ItemStack cursor) {
        if (InventoryUtils.isEmptySlot(cursor) || cursor.isSimilar(result) && cursor.getAmount() + result.getAmount() <= cursor.getMaxStackSize()) {
            return result.getAmount();
        }
        return 0;
    }

    public static int calculateDropCraftAmount(ItemStack result, @Nullable ItemStack cursor) {
        if (cursor != null && cursor.getType().equals((Object)Material.AIR)) {
            return result.getAmount();
        }
        return 0;
    }
}

