/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.util;

import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.config.Config;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;

public class RewardUtil {
    public static Component fillRewardMessage(Player player, Config.DisplayComponent config, List<String> lines, List<Placeholder<?>> placeholders, Collection<Reward> rewards) {
        LocalizationProvider localization = AuroraQuests.getInstance().getLocalizationProvider();
        TextComponent.Builder text = Component.text();
        for (String line : lines) {
            if (line.equals("component:rewards")) {
                if (!rewards.isEmpty()) {
                    text.append(Text.component((Player)player, (String)localization.fillVariables(player, config.getTitle(), placeholders), (Placeholder[])new Placeholder[0]));
                }
                for (Reward reward : rewards) {
                    String rewardText = reward.getDisplay(player, placeholders);
                    if (rewardText.isBlank()) continue;
                    text.append((Component)Component.newline());
                    String display = config.getLine().replace("{reward}", rewardText);
                    text.append(Text.component((Player)player, (String)localization.fillVariables(player, display, placeholders), (Placeholder[])new Placeholder[0]));
                }
            } else {
                text.append(Text.component((Player)player, (String)localization.fillVariables(player, line, placeholders), (Placeholder[])new Placeholder[0]));
            }
            if (line.equals(lines.getLast())) continue;
            text.append((Component)Component.newline());
        }
        return text.build();
    }
}

