/*
 * Decompiled with CFR 0.152.
 */
package me.datsuns.aidiary;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.datsuns.aidiary.AIDiaryClient;
import me.datsuns.aidiary.Stats;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

@Environment(value=EnvType.CLIENT)
public class Diary {
    public final Integer MaxLengthPerOneChat = 240;
    public final String GeminiModelName = "gemini-2.5-flash";
    public GenerationState State;
    public String DiaryText;
    public String ApiKey;

    Diary(String apiKey) {
        this.ApiKey = apiKey;
        this.State = GenerationState.Idle;
    }

    public void onClientTick(class_310 client) {
        if (this.State != GenerationState.Completed) {
            return;
        }
        class_1132 s = client.method_1576();
        if (s == null) {
            AIDiaryClient.LOGGER.error("Diary::onClientTick: client.getServer() ERROR");
            return;
        }
        class_2168 src = s.method_3739();
        class_2170 cm = s.method_3734();
        for (String t : this.usingSplitMethod(this.DiaryText, this.MaxLengthPerOneChat)) {
            String cmd = String.format("say %s", t);
            cm.method_44252(src, cmd);
        }
        this.DiaryText = "";
        this.State = GenerationState.Idle;
    }

    public void onSave(class_310 client, Stats stats) {
        if (this.ApiKey.isEmpty()) {
            AIDiaryClient.LOGGER.error("api key is not set");
            return;
        }
        if (this.State != GenerationState.Idle) {
            AIDiaryClient.LOGGER.error("now on busy. skip.");
        }
        this.State = GenerationState.Generating;
        long days = client.field_1687.method_8532() / 24000L;
        String prompt = this.generatePrompt(days, stats);
        CompletableFuture.runAsync(() -> {
            try {
                this.DiaryText = this.generateDiaryText(prompt);
            }
            catch (IOException e) {
                AIDiaryClient.LOGGER.error("generate error {}", (Throwable)e);
                this.State = GenerationState.Idle;
                return;
            }
            this.State = GenerationState.Completed;
        });
    }

    public String generateDiaryText(String prompt) throws IOException {
        String rawJson = this.issueGeminiRequest(prompt);
        String generated = "";
        try {
            generated = this.parseGeminiResponseJson(rawJson);
        }
        catch (RuntimeException e) {
            AIDiaryClient.LOGGER.error("Generate Error {}", (Throwable)e);
        }
        return generated;
    }

    public String generatePromptContents(HashMap<String, Integer> map, String format) {
        if (map.size() == 0) {
            return "    - nothing\n";
        }
        Object ret = "";
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            ret = (String)ret + String.format(format, entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public String generatePromptContents(ArrayList<String> list, String prefix) {
        Object ret = prefix;
        for (String v : list) {
            ret = (String)ret + String.format("%s,", v);
        }
        return ret;
    }

    public String generatePrompt(long nthDay, Stats stats) {
        Object attacked = "";
        if (stats.Attacked.size() == 0) {
            attacked = "    - nothing\n";
        } else {
            for (Map.Entry<String, HashMap<String, Integer>> entry : stats.Attacked.entrySet()) {
                attacked = (String)attacked + String.format("    - target: %s\n", entry.getKey());
                for (Map.Entry<String, Integer> details : entry.getValue().entrySet()) {
                    attacked = (String)attacked + String.format("       - by %s, %d times\n", details.getKey(), details.getValue());
                }
            }
        }
        String bioms = this.generatePromptContents(stats.VisitedBioms, "   - ");
        String items = this.generatePromptContents(stats.UsedItem, "    - %s, %d times\n");
        String blocks = this.generatePromptContents(stats.UsedBlock, "    - %s, %d times\n");
        String destroyBlocks = this.generatePromptContents(stats.DestroyBlock, "    - %s, %d blocks\n");
        String entities = this.generatePromptContents(stats.UsedEntity, "    - %s, %d times\n");
        return String.format("write a diary about Minecraft in %s with the character encoding set to UTF-8.\nwrite weather and playing day on the top of diary.\nsentences of diary should be funny and passionate.\nwrite within %d lines.\nHere are played information of today.\nThe information below is for reference only.\n- the %d th day of playing \n- move %d meters\n- weather of the day\n- attack result\n%s\n- visited bioms\n%s\n- used items\n%s\n- used blocks\n%s\n- destroy blocks\n%s\n- communicated mobs\n%s\n", class_2561.method_43471((String)"diary.text.language").getString(), 7, nthDay, (int)stats.distance(), attacked, bioms, items, blocks, destroyBlocks, entities);
    }

    private String buildGeminiRequestBody(String prompot) throws IOException {
        JsonObject root = new JsonObject();
        JsonObject child = new JsonObject();
        JsonObject text = new JsonObject();
        text.addProperty("text", prompot);
        child.add("parts", (JsonElement)text);
        root.add("contents", (JsonElement)child);
        return root.toString();
    }

    private String parseGeminiResponseJson(String rawJson) {
        JsonObject jsonObj = (JsonObject)new Gson().fromJson(rawJson, JsonObject.class);
        JsonArray candidates = jsonObj.get("candidates").getAsJsonArray();
        JsonObject candidate = candidates.get(0).getAsJsonObject();
        JsonObject content = candidate.get("content").getAsJsonObject();
        JsonArray parts = content.get("parts").getAsJsonArray();
        JsonObject part = parts.get(0).getAsJsonObject();
        return part.get("text").getAsString();
    }

    private String issueGeminiRequest(String prompot) throws IOException {
        String reqUrl = String.format("https://generativelanguage.googleapis.com/v1beta/models/%s:generateContent?key=%s", "gemini-2.5-flash", this.ApiKey);
        String body = this.buildGeminiRequestBody(prompot);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        StringEntity input = new StringEntity(body);
        HttpPost post = new HttpPost(reqUrl);
        post.setEntity((HttpEntity)input);
        HttpResponse response = client.execute((HttpUriRequest)post);
        HttpEntity httpEntity = response.getEntity();
        InputStream in = httpEntity.getContent();
        return new String(in.readAllBytes(), StandardCharsets.UTF_8);
    }

    List<String> usingSplitMethod(String text, int n) {
        ArrayList<String> chunks = new ArrayList<String>();
        int length = text.length();
        for (int i = 0; i < length; i += n) {
            chunks.add(text.substring(i, Math.min(length, i + n)));
        }
        return chunks;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum GenerationState {
        Idle(0),
        Generating(1),
        Completed(2);

        private final int n;

        private GenerationState(int i) {
            this.n = i;
        }
    }
}

