/*
 * Decompiled with CFR 0.152.
 */
package me.datsuns.aidiary;

import me.datsuns.aidiary.AIDiaryClient;
import me.datsuns.aidiary.Diary;
import me.datsuns.aidiary.Stats;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

@Environment(value=EnvType.CLIENT)
public class Trigger {
    public static final long TIME_PER_DAY = 24000L;
    public Stats Stats;
    public Diary Diary;
    public long CurrentDay;

    Trigger(Stats s, Diary d) {
        this.Stats = s;
        this.Diary = d;
        this.CurrentDay = -1L;
        this.registerCallback();
    }

    public void registerCallback() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            this.onAttackEntityCallback(player, world, hand, entity, hitResult);
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> this.onPlayerBlockBreakEvents(world, player, pos, state, entity));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            this.onUseBlockCallback(player, world, hand, hitResult);
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            this.onUseEntityCallback(player, world, hand, entity, hitResult);
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            this.onUseItemCallback(player, world, hand);
            return class_1269.field_5811;
        });
    }

    public void onUseItemCallback(class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 s = player.method_5998(hand);
        if (s != null) {
            this.Stats.onItemUsed(s.method_7909().method_63680().getString());
        }
    }

    public void onUseEntityCallback(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        if (entity != null) {
            String name = entity.method_5864().method_5897().getString();
            this.Stats.onEntityUsed(name);
        }
    }

    public void onUseBlockCallback(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (hitResult != null && world != null) {
            String block = world.method_8320(hitResult.method_17777()).method_26204().method_9518().getString();
            this.Stats.onBlockUsed(block);
        }
    }

    public void onPlayerBlockBreakEvents(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 entity) {
        if (state != null) {
            String block = state.method_26204().method_9518().getString();
            this.Stats.onBlockDestroy(block);
        }
    }

    public void onAttackEntityCallback(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        if (entity != null) {
            String target = entity.method_5864().method_5897().getString();
            String how = player.method_5998(hand).method_7909().method_63680().getString();
            this.Stats.onClientAttacked(target, how);
        }
    }

    public void onAttackBlockCallback(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        AIDiaryClient.LOGGER.info("onAttackBlockCallback {}", (Object)hand.name());
    }

    public void onEntityTrackingEventsStop(class_1297 trackedEntity, class_3222 player) {
        AIDiaryClient.LOGGER.info("onEntityTrackingEventsStop {}", (Object)trackedEntity.method_5476().getString());
    }

    public void onEntityTrackingEventsStart(class_1297 trackedEntity, class_3222 player) {
        AIDiaryClient.LOGGER.info("onEntityTrackingEventsStart {}", (Object)trackedEntity.method_5476().getString());
    }

    public void onClientPickBlockGather(class_1657 player, class_239 result) {
        AIDiaryClient.LOGGER.info("onClientPickBlockGather");
    }

    public void onClientPickBlockApply(class_1657 player, class_239 result, class_1799 stack) {
        AIDiaryClient.LOGGER.info("onClientPickBlockApply");
    }

    public void onClientTick(class_310 client) {
        if (client == null || client.field_1687 == null) {
            return;
        }
        long tod = client.field_1687.method_8532();
        long days = tod / 24000L;
        if (this.CurrentDay == -1L) {
            this.CurrentDay = days;
            return;
        }
        if (days != this.CurrentDay) {
            this.CurrentDay = days;
            this.Diary.onSave(client, this.Stats);
            this.Stats.reset();
        }
        this.Stats.onClientTick(client);
        this.Diary.onClientTick(client);
    }
}

