/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads;

import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.entity.blockentity.TLRBlockEntity;
import net.rk.longroads.entity.blockentity.model.DynamicDoubleTallSignModel;
import net.rk.longroads.entity.blockentity.model.DynamicRectangleSignModel;
import net.rk.longroads.entity.blockentity.model.DynamicSignModel;
import net.rk.longroads.entity.blockentity.model.HangingRoadwaySignModel;
import net.rk.longroads.entity.blockentity.model.RoadwaySignModel;
import net.rk.longroads.item.TLRItems;
import net.rk.longroads.menu.TLRMenu;
import net.rk.longroads.render.CustomSignRenderer;
import net.rk.longroads.render.DynamicRoadSignBERenderer;
import net.rk.longroads.render.GreenHangingRoadwaySignRenderer;
import net.rk.longroads.screen.DynamicRoadSignScreen;

@Mod(value="thingamajigslongroads", dist={Dist.CLIENT})
public class LongRoadsClient {
    public static final DeferredRegister<CreativeModeTab> CMT_TLR = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"thingamajigslongroads");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TLR_TAB = CMT_TLR.register("trr_main_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.thingamajigslongroads")).withTabsBefore(new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"thingamajigs", (String)"main_ctab")}).icon(() -> ((Item)TLRItems.GREEN_HANGING_ROADWAY_SIGN_ITEM.get()).getDefaultInstance()).backgroundTexture(ResourceLocation.fromNamespaceAndPath((String)"thingamajigs", (String)"textures/gui/thingamajigsitems.png")).withScrollBarSpriteLocation(ResourceLocation.parse((String)"thingamajigs:container/creative_inventory/scroller")).build());

    public LongRoadsClient(IEventBus bus) {
        CMT_TLR.register(bus);
        TLRClientEvents.doStuff(bus);
    }

    public static class TLRClientEvents {
        private static void doStuff(IEventBus modEventBus) {
            modEventBus.addListener(TLRClientEvents::setupBlockEntityRenderers);
            modEventBus.addListener(TLRClientEvents::layerSetup);
            modEventBus.addListener(TLRClientEvents::setupMenuTypes);
            modEventBus.addListener(TLRClientEvents::addCreative);
        }

        public static void setupBlockEntityRenderers(FMLClientSetupEvent event) {
            BlockEntityRenderers.register(TLRBlockEntity.ROADWAY_SIGN.get(), CustomSignRenderer::new);
            BlockEntityRenderers.register(TLRBlockEntity.GREEN_HANGING_ROADWAY_SIGN.get(), GreenHangingRoadwaySignRenderer::new);
            BlockEntityRenderers.register(TLRBlockEntity.DYNAMIC_ROAD_SIGN_BE.get(), DynamicRoadSignBERenderer::new);
        }

        public static void layerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DynamicSignModel.SIGN_TEXTURE_LOCATION, DynamicSignModel::createBodyLayer);
            event.registerLayerDefinition(DynamicRectangleSignModel.RECTANGLE_SIGN_TEXTURE_LOCATION, DynamicRectangleSignModel::createBodyLayer);
            event.registerLayerDefinition(DynamicDoubleTallSignModel.DOUBLE_TALL_SIGN_TEXTURE_LOCATION, DynamicDoubleTallSignModel::createBodyLayer);
            event.registerLayerDefinition(HangingRoadwaySignModel.DEFAULT_MODEL_LAYER_LOCATION, HangingRoadwaySignModel::createBodyLayer);
            event.registerLayerDefinition(RoadwaySignModel.DEFAULT_SIGN_LOCATION, RoadwaySignModel::createBodyLayer);
        }

        public static void setupMenuTypes(RegisterMenuScreensEvent event) {
            event.register((MenuType)TLRMenu.SIGN_MENU.get(), DynamicRoadSignScreen::new);
        }

        public static void addCreative(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == TLR_TAB.getKey()) {
                event.accept(TLRItems.PAINT_BRUSH);
                event.accept(TLRItems.WHITE_PAINT_BRUSH);
                event.accept(TLRItems.YELLOW_PAINT_BRUSH);
                event.accept(TLRItems.BLUE_PAINT_BRUSH);
                event.accept(TLRItems.SCRAPE_TOOL);
                event.accept(TLRItems.DYNAMIC_ROAD_SIGN);
                event.accept(TLRItems.DYNAMIC_STRAIGHT_ROAD_SIGN);
                event.accept(TLRItems.DYNAMIC_THREE_WAY_ROAD_SIGN);
                event.accept(TLRItems.DYNAMIC_VERTICAL_REDSTONE_ROAD_SIGN);
                event.accept(TLRItems.GREEN_ROADWAY_SIGN_ITEM);
                event.accept(TLRItems.GREEN_HANGING_ROADWAY_SIGN_ITEM);
                event.accept(TLRItems.RED_ROADWAY_SIGN_ITEM);
                event.accept(TLRItems.BLUE_ROADWAY_SIGN_ITEM);
                event.accept(TLRItems.BROWN_ROADWAY_SIGN_ITEM);
                event.accept((ItemLike)TLRBlocks.ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.ASPHALT_OK.asItem());
                event.accept((ItemLike)TLRBlocks.ASPHALT_OK_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.ASPHALT_MEDIOCRE.asItem());
                event.accept((ItemLike)TLRBlocks.ASPHALT_MEDIOCRE_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.ASPHALT_OLD.asItem());
                event.accept((ItemLike)TLRBlocks.ASPHALT_OLD_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.DOUBLE_WHITE_ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.DOUBLE_CORNER_WHITE_ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_PARKING_ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_PARKING_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_PARKING_OK_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_PARKING_MEDIOCRE_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_PARKING_OLD_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_D_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_D_OK_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_D_MEDIOCRE_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_D_OLD_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_DT_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_DT_OK_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_DT_MEDIOCRE_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.WHITE_DT_OLD_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.DOUBLE_YELLOW_ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.DOUBLE_CORNER_YELLOW_ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_OK_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_MEDIOCRE_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_OLD_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_D_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_D_OK_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_D_MEDIOCRE_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_D_OLD_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_DT_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_DT_OK_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_DT_MEDIOCRE_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.YELLOW_DT_OLD_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.BLUE_PARKING_ASPHALT.asItem());
                event.accept((ItemLike)TLRBlocks.BLUE_PARKING_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.BLUE_PARKING_OK_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.BLUE_PARKING_MEDIOCRE_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.BLUE_PARKING_OLD_ASPHALT_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.VERTICAL_REDSTONE_SIDEWALK.asItem());
                event.accept((ItemLike)TLRBlocks.SIDEWALK.asItem());
                event.accept((ItemLike)TLRBlocks.SIDEWALK_BLOCKED.asItem());
                event.accept((ItemLike)TLRBlocks.SIDEWALK_SECTIONED.asItem());
                event.accept((ItemLike)TLRBlocks.SIDEWALK_CRACKED.asItem());
                event.accept((ItemLike)TLRBlocks.SIDEWALK_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.BLOCKED_SIDEWALK_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.SECTIONED_SIDEWALK_SLAB.asItem());
                event.accept((ItemLike)TLRBlocks.CRACKED_SIDEWALK_SLAB.asItem());
            }
        }
    }
}

