/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.block.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rk.longroads.datagen.TLRTag;
import net.rk.longroads.entity.blockentity.custom.GreenHangingRoadwaySign;

public class GreenHangingSignBlock
extends CeilingHangingSignBlock {
    public GreenHangingSignBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    protected boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        boolean hasCenterSupportPole = state.is(TLRTag.SUPPORTS_ROAD_HANGING_SIGNS);
        return hasCenterSupportPole || reader.getBlockState(pos.above()).isFaceSturdy((BlockGetter)reader, pos.above(), Direction.DOWN, SupportType.CENTER);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public void appendHoverText(ItemStack is, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"item.green_hanging_sign.desc").withStyle(ChatFormatting.GRAY));
    }

    protected InteractionResult useWithoutItem(BlockState bs, Level level, BlockPos bp, Player player, BlockHitResult bhr) {
        if (!level.isClientSide && player.isSecondaryUseActive()) {
            GreenHangingRoadwaySign be = (GreenHangingRoadwaySign)level.getBlockEntity(bp);
            float pitch = level.getRandom().nextFloat() * 1.25f;
            if (be instanceof GreenHangingRoadwaySign) {
                if (!be.isWaxed()) {
                    be.yAngle += 0.1f;
                    be.updateBlock();
                    level.playSound(null, bp, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 0.5f, 0.95f);
                    return InteractionResult.SUCCESS_SERVER;
                }
                level.playSound(null, bp, SoundEvents.WAXED_HANGING_SIGN_INTERACT_FAIL, SoundSource.BLOCKS, 0.5f, pitch);
                return InteractionResult.CONSUME;
            }
        }
        super.useWithoutItem(bs, level, bp, player, bhr);
        return InteractionResult.PASS;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GreenHangingRoadwaySign(pos, state);
    }
}

