/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.rk.longroads.entity.blockentity.custom.RoadwaySign;
import net.rk.thingamajigs.block.TBlocks;
import net.rk.thingamajigs.datagen.TTag;

public class RoadwayStandingSignBlock
extends StandingSignBlock {
    public RoadwayStandingSignBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    protected InteractionResult useWithoutItem(BlockState bs, Level level, BlockPos bp, Player player, BlockHitResult bhr) {
        if (!level.isClientSide && player.isSecondaryUseActive()) {
            RoadwaySign be = (RoadwaySign)level.getBlockEntity(bp);
            float pitch = level.getRandom().nextFloat() * 1.25f;
            if (be instanceof RoadwaySign) {
                if (!be.isWaxed()) {
                    be.yAngle += 0.1f;
                    be.updateBlock();
                    level.playSound(null, bp, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 0.5f, 0.95f);
                    return InteractionResult.SUCCESS_SERVER;
                }
                level.playSound(null, bp, SoundEvents.WAXED_HANGING_SIGN_INTERACT_FAIL, SoundSource.BLOCKS, 0.5f, pitch);
                return InteractionResult.CONSUME;
            }
        }
        super.useWithoutItem(bs, level, bp, player, bhr);
        return InteractionResult.PASS;
    }

    public boolean canSurvive(BlockState bs, LevelReader lr, BlockPos bp) {
        return lr.getBlockState(bp.below()).isSolid() || lr.getBlockState(bp.below()).is((Block)TBlocks.STRAIGHT_POLE.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.PLUS_POLE.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.HOLDER_POLE.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.TL_CONNECTOR.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.T_POLE_B.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.VERTICAL_T_POLE.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.TRI_POLE_B.get()) || lr.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS) || lr.getBlockState(bp.below()).is((Block)TBlocks.VERTICAL_AXIS_POLE.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.THREE_WAY_POLE.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.ALL_WAY_POLE.get()) || lr.getBlockState(bp.below()).is((Block)TBlocks.CROSSWALK_BUTTON.get());
    }

    public BlockEntity newBlockEntity(BlockPos bp, BlockState bs) {
        return new RoadwaySign(bp, bs);
    }
}

