/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.datagen;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.rk.longroads.datagen.TLRBlockTag;
import net.rk.longroads.datagen.TLRItemTag;
import net.rk.longroads.datagen.TLRLanguage;
import net.rk.longroads.datagen.TLRLoot;
import net.rk.longroads.datagen.TLRModelGen;
import net.rk.longroads.datagen.TLRRecipe;
import net.rk.longroads.registries.SignTypeBootstrap;
import net.rk.longroads.registries.TLRRegistries;

@EventBusSubscriber(modid="thingamajigslongroads")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherClientData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new TLRLanguage(packOutput, "en_us"));
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(TLRLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        TLRBlockTag blockTags = new TLRBlockTag(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTags);
        event.getGenerator().addProvider(true, (DataProvider)new TLRItemTag(packOutput, lookupProvider, blockTags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new TLRRecipe.RecipeRunner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TLRModelGen(packOutput));
        event.getGenerator().addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), new RegistrySetBuilder().add(TLRRegistries.SIGN_TYPE, SignTypeBootstrap::bootstrap), Set.of("thingamajigslongroads")));
    }

    @SubscribeEvent
    public static void gatherServerData(GatherDataEvent.Server event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new TLRLanguage(packOutput, "en_us"));
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(TLRLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        TLRBlockTag blockTags = new TLRBlockTag(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTags);
        event.getGenerator().addProvider(true, (DataProvider)new TLRItemTag(packOutput, lookupProvider, blockTags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new TLRRecipe.RecipeRunner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TLRModelGen(packOutput));
        event.getGenerator().addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), new RegistrySetBuilder().add(TLRRegistries.SIGN_TYPE, SignTypeBootstrap::bootstrap), Set.of("thingamajigslongroads")));
    }
}

