/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.datagen;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.datagen.TLRTag;
import net.rk.longroads.item.TLRItems;
import net.rk.longroads.registries.SignType;
import net.rk.longroads.util.SignTypeKeys;

public class TLRLanguage
extends LanguageProvider {
    public TLRLanguage(PackOutput output, String locale) {
        super(output, "thingamajigslongroads", locale);
    }

    public void addSignType(ResourceKey<SignType> signType, String name) {
        this.add("sign_type." + signType.location().getPath() + ".name", name);
    }

    public void addBlockDesc(Block block, String description) {
        this.add(block.getDescriptionId() + ".desc", description);
    }

    protected void addTranslations() {
        this.add("itemGroup.thingamajigslongroads", "Thingamajigs Long Roads");
        this.add("item.paint_brush.data.pattern_type", "Type: %s");
        this.add("item.thingamajigslongroads.scrape_tool.desc", "Scrapes paint off of asphalt and other blocks");
        this.add("container.thingamajigslongroads.dynamic_sign.sign_type", "Type: ");
        this.add("editbox.thingamajigslongroads.hint.dynamic_sign", "Type Resource Here");
        this.add("title.thingamajigslongroads.dynamic_road_sign", "Dynamic Sign");
        this.add("button.thingamajigslongroads.rotation_left", "<- Rotation");
        this.add("button.thingamajigslongroads.rotation_right", "Rotation ->");
        this.add("button.thingamajigslongroads.round_rotation", "Round \u21ba");
        this.addBlockDesc((Block)TLRBlocks.ROAD_SIGN.get(), "Dynamically renders any SignType that is defined in datapacks. Can be Square, Double Tall, or Rectangular shaped.");
        this.add("item.green_hanging_sign.desc", "Can be rotated when shift-clicking the sign");
        this.addTag(() -> TLRTag.ASPHALT_ITEMS, "Asphalt Items");
        this.addTag(() -> TLRTag.ASPHALT_BLOCKS, "Asphalt Blocks");
        this.addTag(() -> TLRTag.ASPHALT_SLABS_ITEMS, "Asphalt Slab Items");
        this.addTag(() -> TLRTag.ASPHALT_SLABS_BLOCKS, "Asphalt Slab Blocks");
        this.addTag(() -> TLRTag.ROAD_SIGN_CRAFTING_GLOBS, "Road Sign Crafting Globs");
        this.addSignType(SignTypeKeys.PlACEHOLDER, "Placeholder For Fun!");
        this.addBlock((Supplier)TLRBlocks.VERTICAL_REDSTONE_SIDEWALK, "Vertical Redstone Sidewalk");
        this.addBlock((Supplier)TLRBlocks.ROAD_SIGN, "Road Sign (Plus Pole)");
        this.addBlock((Supplier)TLRBlocks.STRAIGHT_ROAD_SIGN, "Road Sign (Vertical Pole)");
        this.addBlock((Supplier)TLRBlocks.THREE_WAY_ROAD_SIGN, "Road Sign (Three-Way Pole)");
        this.addBlock((Supplier)TLRBlocks.VERTICAL_REDSTONE_ROAD_SIGN, "Road Sign (Vertical Redstone Pole)");
        this.addBlock((Supplier)TLRBlocks.ASPHALT, "Asphalt");
        this.addBlock((Supplier)TLRBlocks.ASPHALT_OK, "Ok Asphalt");
        this.addBlock((Supplier)TLRBlocks.ASPHALT_MEDIOCRE, "Mediocre Asphalt");
        this.addBlock((Supplier)TLRBlocks.ASPHALT_OLD, "Old Asphalt");
        this.addBlock((Supplier)TLRBlocks.ASPHALT_SLAB, "Asphalt Slab");
        this.addBlock((Supplier)TLRBlocks.ASPHALT_OK_SLAB, "Ok Asphalt Slab");
        this.addBlock((Supplier)TLRBlocks.ASPHALT_MEDIOCRE_SLAB, "Mediocre Asphalt Slab");
        this.addBlock((Supplier)TLRBlocks.ASPHALT_OLD_SLAB, "Old Asphalt Slab");
        this.addBlock((Supplier)TLRBlocks.SIDEWALK, "Sidewalk");
        this.addBlock((Supplier)TLRBlocks.SIDEWALK_CRACKED, "Cracked Sidewalk");
        this.addBlock((Supplier)TLRBlocks.SIDEWALK_BLOCKED, "Blocked Sidewalk");
        this.addBlock((Supplier)TLRBlocks.SIDEWALK_SECTIONED, "Sectioned Sidewalk");
        this.addBlock((Supplier)TLRBlocks.SIDEWALK_SLAB, "Sidewalk Slab");
        this.addBlock((Supplier)TLRBlocks.CRACKED_SIDEWALK_SLAB, "Cracked Sidewalk Slab");
        this.addBlock((Supplier)TLRBlocks.BLOCKED_SIDEWALK_SLAB, "Blocked Sidewalk Slab");
        this.addBlock((Supplier)TLRBlocks.SECTIONED_SIDEWALK_SLAB, "Sectioned Sidewalk Slab");
        this.addBlock((Supplier)TLRBlocks.DOUBLE_WHITE_ASPHALT, "Double White Asphalt");
        this.addBlock((Supplier)TLRBlocks.DOUBLE_CORNER_WHITE_ASPHALT, "Double Corner White Asphalt");
        this.addBlock((Supplier)TLRBlocks.DOUBLE_YELLOW_ASPHALT, "Double Yellow Asphalt");
        this.addBlock((Supplier)TLRBlocks.DOUBLE_CORNER_YELLOW_ASPHALT, "Double Corner Yellow Asphalt");
        this.addBlock((Supplier)TLRBlocks.WHITE_PARKING_ASPHALT, "White Parking Asphalt");
        this.addBlock((Supplier)TLRBlocks.YELLOW_PARKING_ASPHALT, "Yellow Parking Asphalt");
        this.addBlock((Supplier)TLRBlocks.BLUE_PARKING_ASPHALT, "Blue Parking Asphalt");
        this.addBlock((Supplier)TLRBlocks.WHITE_PARKING_ASPHALT_SLAB, "Asphalt Slab (Thin White Parking Line)");
        this.addBlock((Supplier)TLRBlocks.WHITE_PARKING_OK_ASPHALT_SLAB, "Ok Asphalt Slab (Thin White Parking Line)");
        this.addBlock((Supplier)TLRBlocks.WHITE_PARKING_MEDIOCRE_ASPHALT_SLAB, "Mediocre Asphalt Slab (Thin White Parking Line)");
        this.addBlock((Supplier)TLRBlocks.WHITE_PARKING_OLD_ASPHALT_SLAB, "Old Asphalt Slab (Thin White Parking Line)");
        this.addBlock((Supplier)TLRBlocks.WHITE_DT_ASPHALT_SLAB, "Asphalt Slab (Double White Corner)");
        this.addBlock((Supplier)TLRBlocks.WHITE_DT_OK_ASPHALT_SLAB, "Ok Asphalt Slab (Double White Corner)");
        this.addBlock((Supplier)TLRBlocks.WHITE_DT_MEDIOCRE_ASPHALT_SLAB, "Mediocre Asphalt Slab (Double White Corner)");
        this.addBlock((Supplier)TLRBlocks.WHITE_DT_OLD_ASPHALT_SLAB, "Old Asphalt Slab (Double White Corner)");
        this.addBlock((Supplier)TLRBlocks.BLUE_PARKING_ASPHALT_SLAB, "Asphalt Slab (Thin Blue Parking Line)");
        this.addBlock((Supplier)TLRBlocks.BLUE_PARKING_OK_ASPHALT_SLAB, "Ok Asphalt Slab (Thin Blue Parking Line)");
        this.addBlock((Supplier)TLRBlocks.BLUE_PARKING_MEDIOCRE_ASPHALT_SLAB, "Mediocre Asphalt Slab (Thin Blue Parking Line)");
        this.addBlock((Supplier)TLRBlocks.BLUE_PARKING_OLD_ASPHALT_SLAB, "Old Asphalt Slab (Thin Blue Parking Line)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_DT_ASPHALT_SLAB, "Asphalt Slab (Double Yellow Corner)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_DT_OK_ASPHALT_SLAB, "Ok Asphalt Slab (Double Yellow Corner)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_DT_MEDIOCRE_ASPHALT_SLAB, "Mediocre Asphalt Slab (Double Yellow Corner)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_DT_OLD_ASPHALT_SLAB, "Old Asphalt Slab (Double Yellow Corner)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_PARKING_ASPHALT_SLAB, "Asphalt Slab (Thin Yellow Parking Line)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_PARKING_OK_ASPHALT_SLAB, "Ok Asphalt Slab (Thin Yellow Parking Line)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_PARKING_MEDIOCRE_ASPHALT_SLAB, "Mediocre Asphalt Slab (Thin Yellow Parking Line)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_PARKING_OLD_ASPHALT_SLAB, "Old Asphalt Slab (Thin Yellow Parking Line)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_D_ASPHALT_SLAB, "Asphalt Slab (Double Yellow)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_D_OK_ASPHALT_SLAB, "Ok Asphalt Slab (Double Yellow)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_D_MEDIOCRE_ASPHALT_SLAB, "Mediocre Asphalt Slab (Double Yellow)");
        this.addBlock((Supplier)TLRBlocks.YELLOW_D_OLD_ASPHALT_SLAB, "Old Asphalt Slab (Double Yellow)");
        this.addBlock((Supplier)TLRBlocks.WHITE_D_ASPHALT_SLAB, "Asphalt Slab (Double White)");
        this.addBlock((Supplier)TLRBlocks.WHITE_D_OK_ASPHALT_SLAB, "Ok Asphalt Slab (Double White)");
        this.addBlock((Supplier)TLRBlocks.WHITE_D_MEDIOCRE_ASPHALT_SLAB, "Mediocre Asphalt Slab (Double White)");
        this.addBlock((Supplier)TLRBlocks.WHITE_D_OLD_ASPHALT_SLAB, "Old Asphalt Slab (Double White)");
        this.addItem(() -> TLRBlocks.ROAD_SIGN.asItem(), "Road Sign (Plus Pole)");
        this.addItem(() -> TLRBlocks.STRAIGHT_ROAD_SIGN.asItem(), "Road Sign (Vertical Pole)");
        this.addItem(() -> TLRBlocks.THREE_WAY_ROAD_SIGN.asItem(), "Road Sign (Three-Way Pole)");
        this.addItem(() -> TLRBlocks.VERTICAL_REDSTONE_ROAD_SIGN.asItem(), "Road Sign (Vertical Redstone Pole)");
        this.addItem((Supplier)TLRItems.SCRAPE_TOOL, "Scrape Tool");
        this.addItem((Supplier)TLRItems.PAINT_BRUSH, "Paintbrush");
        this.addItem((Supplier)TLRItems.WHITE_PAINT_BRUSH, "White Paintbrush");
        this.addItem((Supplier)TLRItems.YELLOW_PAINT_BRUSH, "Yellow Paintbrush");
        this.addItem((Supplier)TLRItems.BLUE_PAINT_BRUSH, "Blue Paintbrush");
        this.addItem((Supplier)TLRItems.GREEN_ROADWAY_SIGN_ITEM, "Green Roadway Sign");
        this.addItem((Supplier)TLRItems.GREEN_HANGING_ROADWAY_SIGN_ITEM, "Hanging Green Roadway Sign");
        this.addItem((Supplier)TLRItems.RED_ROADWAY_SIGN_ITEM, "Red Roadway Sign");
        this.addItem((Supplier)TLRItems.BLUE_ROADWAY_SIGN_ITEM, "Blue Roadway Sign");
        this.addItem((Supplier)TLRItems.BROWN_ROADWAY_SIGN_ITEM, "Brown Roadway Sign");
        this.addBlock((Supplier)TLRBlocks.WHITE_ROAD_MARKING, "White Road Marking");
        this.addBlock((Supplier)TLRBlocks.YELLOW_ROAD_MARKING, "Yellow Road Marking");
        this.addBlock((Supplier)TLRBlocks.BLUE_ROAD_MARKING, "Blue Road Marking");
    }
}

