/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.entity.blockentity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.rk.longroads.entity.blockentity.TLRBlockEntity;

public class RoadwaySign
extends SignBlockEntity {
    public float yAngle = 0.0f;
    public boolean goRainbow = false;
    public float northRot = 180.0f;
    public float southRot = 0.0f;
    public float eastRot = 180.0f;
    public float westRot = 180.0f;

    public RoadwaySign(BlockPos pos, BlockState state) {
        super(TLRBlockEntity.ROADWAY_SIGN.get(), pos, state);
    }

    public RoadwaySign(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void updateBlock() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState bs2 = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), bs2, bs2, 3);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.yAngle = tag.getFloat("y_angle");
        this.goRainbow = tag.getBoolean("color_crazy");
        this.northRot = tag.getFloat("north_rot");
        this.southRot = tag.getFloat("south_rot");
        this.eastRot = tag.getFloat("east_rot");
        this.westRot = tag.getFloat("west_rot");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("y_angle", this.yAngle);
        tag.putBoolean("color_crazy", this.goRainbow);
        tag.putFloat("north_rot", this.northRot);
        tag.putFloat("south_rot", this.southRot);
        tag.putFloat("east_rot", this.eastRot);
        tag.putFloat("west_rot", this.westRot);
    }
}

