/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.block.custom.Asphalt;
import net.rk.longroads.block.custom.AsphaltSlab;
import net.rk.longroads.block.custom.BlueRoadMarking;
import net.rk.longroads.block.custom.MarkedAsphalt;
import net.rk.longroads.block.custom.RotatingSlab;
import net.rk.longroads.item.TLRDataComponents;
import net.rk.longroads.item.legacyruns.ChangeTypeBlue;

public class BluePaintBrush
extends Item {
    public String currentname = "No Pattern Selected";
    private final DataComponentType<Integer> road_marking = (DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get();

    public BluePaintBrush(Item.Properties p) {
        super(p.durability(3000).stacksTo(1));
    }

    public void typeToName(int type) {
        switch (type) {
            case 0: {
                this.currentname = "Thin Corner";
                break;
            }
            case 1: {
                this.currentname = "Thin Parking Line";
                break;
            }
            case 2: {
                this.currentname = "Thick Parking Line";
                break;
            }
            case 3: {
                this.currentname = "Sidewalk Line";
                break;
            }
            case 4: {
                this.currentname = "Thin Corner Dot";
                break;
            }
            case 5: {
                this.currentname = "Disabled Parking";
                break;
            }
            case 6: {
                this.currentname = "Disabled Parking (Alt)";
                break;
            }
            case 7: {
                this.currentname = "Short Line";
                break;
            }
            case 8: {
                this.currentname = "Short 'T'";
                break;
            }
            case 9: {
                this.currentname = "Plus";
                break;
            }
            case 10: {
                this.currentname = "Square";
                break;
            }
            case 11: {
                this.currentname = "Center 'T'";
                break;
            }
            case 12: {
                this.currentname = "Long 'T'";
                break;
            }
            case 13: {
                this.currentname = "blue marking";
                break;
            }
            default: {
                this.currentname = "undefined";
            }
        }
    }

    public InteractionResult useOn(UseOnContext pContext) {
        if (!pContext.getLevel().isClientSide()) {
            Level levelAccessor = pContext.getLevel();
            Level level = pContext.getLevel();
            BlockPos positionClicked = pContext.getClickedPos();
            Block blockClicked = level.getBlockState(positionClicked).getBlock();
            ItemStack stack = pContext.getItemInHand();
            Block marking = (Block)TLRBlocks.BLUE_ROAD_MARKING.get();
            Player ply = pContext.getPlayer();
            int marking_type = 0;
            if (blockClicked instanceof AsphaltSlab && !ply.isShiftKeyDown()) {
                BlockState oldState = pContext.getLevel().getBlockState(pContext.getClickedPos());
                BlockState paintAsp = ((Block)TLRBlocks.BLUE_PARKING_ASPHALT_SLAB.get()).defaultBlockState();
                if (ply.getItemInHand(ply.getUsedItemHand()).has(this.road_marking)) {
                    int type = (Integer)ply.getItemInHand(ply.getUsedItemHand()).get(this.road_marking);
                    SlabType top = SlabType.TOP;
                    SlabType bottom = SlabType.BOTTOM;
                    SlabType d = SlabType.DOUBLE;
                    SlabType slab = top;
                    if (oldState.getValue((Property)SlabBlock.TYPE) == top) {
                        slab = top;
                    } else if (oldState.getValue((Property)SlabBlock.TYPE) == bottom) {
                        slab = bottom;
                    } else if (oldState.getValue((Property)SlabBlock.TYPE) == d) {
                        slab = d;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_SLAB.get()) {
                        if (type == 1) {
                            paintAsp = ((Block)TLRBlocks.BLUE_PARKING_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue(RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_OK_SLAB.get()) {
                        if (type == 1) {
                            paintAsp = ((Block)TLRBlocks.BLUE_PARKING_OK_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue(RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_MEDIOCRE_SLAB.get()) {
                        if (type == 1) {
                            paintAsp = ((Block)TLRBlocks.BLUE_PARKING_MEDIOCRE_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue(RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_OLD_SLAB.get()) {
                        if (type == 1) {
                            paintAsp = ((Block)TLRBlocks.BLUE_PARKING_OLD_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue(RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                }
            }
            if (blockClicked instanceof Asphalt && !ply.isShiftKeyDown()) {
                BlockState paintAsp = ((Block)TLRBlocks.BLUE_PARKING_ASPHALT.get()).defaultBlockState();
                if (ply.getItemInHand(ply.getUsedItemHand()).has(this.road_marking)) {
                    int type = (Integer)ply.getItemInHand(ply.getUsedItemHand()).get(this.road_marking);
                    int age = 0;
                    boolean notValid = false;
                    if (blockClicked == TLRBlocks.ASPHALT.get()) {
                        age = 0;
                    } else if (blockClicked == TLRBlocks.ASPHALT_OK.get()) {
                        age = 1;
                    } else if (blockClicked == TLRBlocks.ASPHALT_MEDIOCRE.get()) {
                        age = 2;
                    } else if (blockClicked == TLRBlocks.ASPHALT_OLD.get()) {
                        age = 3;
                    } else {
                        notValid = true;
                    }
                    if (!notValid) {
                        if (type == 1) {
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue(MarkedAsphalt.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)MarkedAsphalt.AGE, (Comparable)Integer.valueOf(age)), 3);
                            return this.finished(ply);
                        }
                        notValid = true;
                    }
                }
            }
            if (pContext.getHand() == InteractionHand.MAIN_HAND) {
                if (pContext.getPlayer().isShiftKeyDown()) {
                    if (stack.has(this.road_marking)) {
                        this.increaseType(stack);
                        marking_type = (Integer)stack.get(this.road_marking);
                        level.playSound(null, positionClicked, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        stack.set(this.road_marking, (Object)0);
                        level.playSound(null, positionClicked, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    if (stack.has(this.road_marking)) {
                        marking_type = (Integer)stack.get(this.road_marking);
                    }
                    ChangeTypeBlue.execute((LevelAccessor)levelAccessor, pContext.getClickedPos().getX(), pContext.getClickedPos().getY(), pContext.getClickedPos().getZ(), (Entity)pContext.getPlayer(), stack, marking_type);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult finished(Player ply) {
        ply.swing(ply.getUsedItemHand());
        return InteractionResult.CONSUME;
    }

    private void increaseType(ItemStack stack) {
        if (stack.has(this.road_marking)) {
            stack.set(this.road_marking, (Object)((Integer)stack.get(this.road_marking) + 1));
            if ((Integer)stack.get(this.road_marking) >= BlueRoadMarking.getMaxTypes()) {
                stack.set(this.road_marking, (Object)0);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.thingamajigs.paintbrush"));
        if (stack.has(this.road_marking)) {
            this.typeToName((Integer)stack.get(this.road_marking));
            tooltipComponents.add((Component)Component.translatable((String)"item.paint_brush.data.pattern_type", (Object[])new Object[]{(int)((Integer)stack.get(this.road_marking))}));
            tooltipComponents.add((Component)Component.literal((String)this.currentname).withStyle(ChatFormatting.GREEN));
        }
    }
}

