/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.block.custom.BlueRoadMarking;
import net.rk.longroads.block.custom.MarkedAsphalt;
import net.rk.longroads.block.custom.MarkedAsphaltSlab;
import net.rk.longroads.block.custom.WhiteRoadMarking;
import net.rk.longroads.block.custom.YellowRoadMarking;

public class ScrapeTool
extends Item {
    public ScrapeTool(Item.Properties p) {
        super(p.durability(3000).stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Block blk = ctx.getLevel().getBlockState(ctx.getClickedPos()).getBlock();
        BlockState bs = ctx.getLevel().getBlockState(ctx.getClickedPos());
        Level lvl = ctx.getLevel();
        BlockPos bp = ctx.getClickedPos();
        if (blk instanceof WhiteRoadMarking || blk instanceof YellowRoadMarking || blk instanceof BlueRoadMarking) {
            for (int i = 0; i < 17; ++i) {
                Vec3 vec3 = Vec3.atCenterOf((Vec3i)bp).add(0.0, 0.75, 0.0);
                lvl.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, bs), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
            }
            lvl.playSound(null, bp, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            lvl.destroyBlock(bp, false);
            ctx.getPlayer().swing(ctx.getHand());
            return InteractionResult.CONSUME;
        }
        if (blk instanceof MarkedAsphalt) {
            if ((Integer)bs.getValue((Property)MarkedAsphalt.AGE) == 0) {
                ScrapeTool.changeIt(lvl, bs, ((Block)TLRBlocks.ASPHALT.get()).defaultBlockState(), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
            if ((Integer)bs.getValue((Property)MarkedAsphalt.AGE) == 1) {
                ScrapeTool.changeIt(lvl, bs, ((Block)TLRBlocks.ASPHALT_OK.get()).defaultBlockState(), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
            if ((Integer)bs.getValue((Property)MarkedAsphalt.AGE) == 2) {
                ScrapeTool.changeIt(lvl, bs, ((Block)TLRBlocks.ASPHALT_MEDIOCRE.get()).defaultBlockState(), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
            if ((Integer)bs.getValue((Property)MarkedAsphalt.AGE) == 3) {
                ScrapeTool.changeIt(lvl, bs, ((Block)TLRBlocks.ASPHALT_OLD.get()).defaultBlockState(), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
        } else if (blk instanceof MarkedAsphaltSlab) {
            if (bs.is((Block)TLRBlocks.WHITE_PARKING_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_DT_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_D_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_PARKING_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_DT_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_D_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.BLUE_PARKING_ASPHALT_SLAB.get())) {
                ScrapeTool.changeIt(lvl, bs, (BlockState)((Block)TLRBlocks.ASPHALT_SLAB.get()).defaultBlockState().setValue((Property)MarkedAsphaltSlab.TYPE, (Comparable)((SlabType)bs.getValue((Property)SlabBlock.TYPE))), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
            if (bs.is((Block)TLRBlocks.WHITE_PARKING_OK_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_DT_OK_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_D_OK_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_PARKING_OK_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_DT_OK_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_D_OK_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.BLUE_PARKING_OK_ASPHALT_SLAB.get())) {
                ScrapeTool.changeIt(lvl, bs, (BlockState)((Block)TLRBlocks.ASPHALT_OK_SLAB.get()).defaultBlockState().setValue((Property)MarkedAsphaltSlab.TYPE, (Comparable)((SlabType)bs.getValue((Property)SlabBlock.TYPE))), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
            if (bs.is((Block)TLRBlocks.WHITE_PARKING_MEDIOCRE_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_DT_MEDIOCRE_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_D_MEDIOCRE_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_PARKING_MEDIOCRE_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_DT_MEDIOCRE_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_D_MEDIOCRE_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.BLUE_PARKING_MEDIOCRE_ASPHALT_SLAB.get())) {
                ScrapeTool.changeIt(lvl, bs, (BlockState)((Block)TLRBlocks.ASPHALT_MEDIOCRE_SLAB.get()).defaultBlockState().setValue((Property)MarkedAsphaltSlab.TYPE, (Comparable)((SlabType)bs.getValue((Property)SlabBlock.TYPE))), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
            if (bs.is((Block)TLRBlocks.WHITE_PARKING_OLD_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_DT_OLD_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.WHITE_D_OLD_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_PARKING_OLD_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_DT_OLD_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.YELLOW_D_OLD_ASPHALT_SLAB.get()) || bs.is((Block)TLRBlocks.BLUE_PARKING_OLD_ASPHALT_SLAB.get())) {
                ScrapeTool.changeIt(lvl, bs, (BlockState)((Block)TLRBlocks.ASPHALT_OLD_SLAB.get()).defaultBlockState().setValue((Property)MarkedAsphaltSlab.TYPE, (Comparable)((SlabType)bs.getValue((Property)SlabBlock.TYPE))), bp);
                ctx.getPlayer().swing(ctx.getHand());
                return InteractionResult.CONSUME;
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private static void changeIt(Level lvl, BlockState bs, BlockState nBs, BlockPos bp) {
        for (int i = 0; i < 17; ++i) {
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)bp).add(0.0, 0.75, 0.0);
            lvl.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, bs), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
        }
        lvl.setBlock(bp, nBs, 3);
        lvl.playSound(null, bp, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.thingamajigslongroads.scrape_tool.desc").withStyle(ChatFormatting.GRAY));
    }
}

