/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.entity.blockentity.custom.RoadwaySign;
import net.rk.longroads.entity.blockentity.model.RoadwaySignModel;
import net.rk.thingamajigs.xtras.TColors;
import org.joml.Quaternionf;

public class CustomSignRenderer<T extends RoadwaySign>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation RED_ROADWAY_SIGN = ResourceLocation.parse((String)"thingamajigslongroads:textures/entity/red_roadway_sign.png");
    public static final ResourceLocation BLUE_ROADWAY_SIGN = ResourceLocation.parse((String)"thingamajigslongroads:textures/entity/blue_roadway_sign.png");
    public static final ResourceLocation GREEN_ROADWAY_SIGN = ResourceLocation.parse((String)"thingamajigslongroads:textures/entity/roadway_sign.png");
    public static final ResourceLocation BROWN_ROADWAY_SIGN = ResourceLocation.parse((String)"thingamajigslongroads:textures/entity/brown_roadway_sign.png");
    public RoadwaySignModel model;
    public Font font;
    public Random rnd = new Random();

    public CustomSignRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new RoadwaySignModel(context.bakeLayer(RoadwaySignModel.DEFAULT_SIGN_LOCATION));
        this.font = context.getFont();
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedColor) {
        T abstractSign = blockEntity;
        poseStack.pushPose();
        if (abstractSign instanceof RoadwaySign) {
            if (abstractSign.getBlockState().getBlock() instanceof StandingSignBlock) {
                boolean isWallSign = false;
                this.model.base.visible = true;
                poseStack.translate(0.5f, 0.5f, 0.5f);
                poseStack.scale(0.75f, 0.75f, 0.75f);
            } else if (abstractSign.getBlockState().getBlock() instanceof WallSignBlock) {
                boolean isWallSign = true;
                this.model.base.visible = false;
                if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.SOUTH) {
                    poseStack.translate(0.5f, 0.0f, 0.0f);
                } else if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.NORTH) {
                    poseStack.translate(0.5f, 0.0f, 1.0f);
                } else if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.EAST) {
                    poseStack.translate(0.0f, 0.0f, 0.5f);
                } else if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.WEST) {
                    poseStack.translate(1.0f, 0.0f, 0.5f);
                }
                poseStack.scale(0.5f, 0.75f, 0.5f);
            } else {
                this.model.base.visible = true;
            }
            VertexConsumer vc = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)GREEN_ROADWAY_SIGN));
            if (abstractSign.getBlockState().getBlock() == TLRBlocks.RED_ROADWAY_STANDING_SIGN.get() || abstractSign.getBlockState().getBlock() == TLRBlocks.RED_ROADWAY_WALL_SIGN.get()) {
                vc = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)RED_ROADWAY_SIGN));
            } else if (abstractSign.getBlockState().getBlock() == TLRBlocks.BLUE_ROADWAY_STANDING_SIGN.get() || abstractSign.getBlockState().getBlock() == TLRBlocks.BLUE_ROADWAY_WALL_SIGN.get()) {
                vc = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)BLUE_ROADWAY_SIGN));
            } else if (abstractSign.getBlockState().getBlock() == TLRBlocks.BROWN_ROADWAY_STANDING_SIGN.get() || abstractSign.getBlockState().getBlock() == TLRBlocks.BROWN_ROADWAY_WALL_SIGN.get()) {
                vc = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)BROWN_ROADWAY_SIGN));
            }
            if (abstractSign.getBlockState().getBlock() instanceof WallSignBlock) {
                if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.NORTH) {
                    poseStack.mulPose(new Quaternionf().rotateY(3.15f));
                } else if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.SOUTH) {
                    poseStack.mulPose(new Quaternionf().rotateY(3.14f));
                } else if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.EAST) {
                    poseStack.mulPose(new Quaternionf().rotateY(1.57f));
                } else if (abstractSign.getBlockState().getValue((Property)WallSignBlock.FACING) == Direction.WEST) {
                    poseStack.mulPose(new Quaternionf().rotateY(-1.57f));
                }
            } else {
                poseStack.mulPose(new Quaternionf().rotateY(((RoadwaySign)((Object)abstractSign)).yAngle));
            }
            this.model.main.y = -10.5f;
            this.model.main.xRot = (float)Math.PI;
            this.model.renderToBuffer(poseStack, vc, packedLight, packedColor);
            this.renderTextOnSign(blockEntity, partialTicks, blockEntity.getBlockPos(), blockEntity.getFrontText(), poseStack, bufferSource, packedLight, blockEntity.getTextLineHeight(), blockEntity.getMaxTextLineWidth(), false);
            this.renderTextOnSign(blockEntity, partialTicks, blockEntity.getBlockPos(), blockEntity.getBackText(), poseStack, bufferSource, packedLight, blockEntity.getTextLineHeight(), blockEntity.getMaxTextLineWidth(), true);
        }
        poseStack.popPose();
    }

    public void renderTextOnSign(T blockEntity, float ticks, BlockPos pos, SignText signText, PoseStack poseStack, MultiBufferSource mbs, int i222, int i2, int i3, boolean bool) {
        int l;
        boolean shouldRenderOutline;
        int k;
        int j;
        poseStack.pushPose();
        boolean isWall = blockEntity.getBlockState().getBlock() instanceof WallSignBlock;
        if (isWall) {
            if (bool) {
                switch ((Direction)blockEntity.getBlockState().getValue((Property)WallSignBlock.FACING)) {
                    case NORTH: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).northRot));
                        break;
                    }
                    case SOUTH: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).southRot));
                        break;
                    }
                    case EAST: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).eastRot));
                        break;
                    }
                    case WEST: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).westRot));
                        break;
                    }
                }
            } else {
                switch ((Direction)blockEntity.getBlockState().getValue((Property)WallSignBlock.FACING)) {
                    case NORTH: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).northRot + 180.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).southRot + 180.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).eastRot + 180.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.mulPose(Axis.YP.rotationDegrees(((RoadwaySign)((Object)blockEntity)).westRot + 180.0f));
                        break;
                    }
                }
            }
        } else if (!bool) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        float scaleOfText = 0.0141f;
        float scaleOfTextWall = 0.014f;
        poseStack.translate(new Vec3(0.0, (double)0.6f, (double)0.073f));
        if (blockEntity.getBlockState().getBlock() instanceof StandingSignBlock) {
            poseStack.scale(scaleOfText, -scaleOfText, scaleOfText);
        } else if (blockEntity.getBlockState().getBlock() instanceof WallSignBlock) {
            poseStack.scale(scaleOfText, -scaleOfTextWall, scaleOfText);
        }
        int textColor = signText.getColor().getTextColor();
        int i = 0;
        if (((RoadwaySign)((Object)blockEntity)).goRainbow && blockEntity.getLevel().getGameTime() % 4L == 0L) {
            int r = ARGB.red((int)(this.rnd.nextInt() * TColors.getWhite() - 100000));
            int g = ARGB.green((int)(this.rnd.nextInt() * TColors.getWhite() - 100000));
            int b = ARGB.blue((int)(this.rnd.nextInt() * TColors.getWhite() - 100000));
            i = ARGB.color((int)1, (int)r, (int)g, (int)b);
        } else if (textColor == DyeColor.BLACK.getTextColor() && signText.hasGlowingText()) {
            i = -988212;
        } else {
            j = (int)((double)ARGB.red((int)textColor) * 0.4);
            int k2 = (int)((double)ARGB.green((int)textColor) * 0.4);
            int l2 = (int)((double)ARGB.blue((int)textColor) * 0.4);
            i = ARGB.color((int)0, (int)j, (int)k2, (int)l2);
        }
        j = 4 * i2 / 2;
        FormattedCharSequence[] aformattedcharsequence = signText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), component -> {
            List list = this.font.split((FormattedText)component, i3);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        if (signText.hasGlowingText()) {
            k = signText.getColor().getTextColor();
            shouldRenderOutline = CustomSignRenderer.outline(blockEntity, pos, k);
            l = 0xF000F0;
        } else {
            k = i;
            shouldRenderOutline = false;
            l = i222;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f = -this.font.width(formattedcharsequence) / 2;
            if (shouldRenderOutline) {
                this.font.drawInBatch8xOutline(formattedcharsequence, f, (float)(i1 * i2 - j), k, i, poseStack.last().pose(), mbs, l);
                continue;
            }
            this.font.drawInBatch(formattedcharsequence, f, (float)(i1 * i2 - j), k, false, poseStack.last().pose(), mbs, Font.DisplayMode.POLYGON_OFFSET, 0, l);
        }
        poseStack.popPose();
    }

    public static boolean outline(RoadwaySign blockEntity, BlockPos pos, int color) {
        Entity entity;
        if (color == DyeColor.BLACK.getTextColor()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        if (localplayer != null && minecraft.options.getCameraType().isFirstPerson() && localplayer.isScoping()) {
            return true;
        }
        int distance = 64;
        if (blockEntity.goRainbow) {
            distance = 16;
        }
        return (entity = minecraft.getCameraEntity()) != null && entity.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < (double)distance;
    }
}

