/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.block.custom.GreenHangingWallSignBlock;
import net.rk.longroads.entity.blockentity.custom.GreenHangingRoadwaySign;
import net.rk.longroads.entity.blockentity.model.HangingRoadwaySignModel;
import org.joml.Quaternionf;

public class GreenHangingRoadwaySignRenderer
implements BlockEntityRenderer<GreenHangingRoadwaySign> {
    private static final int OUTLINE_RENDER_DISTANCE = Mth.square((int)16);
    public final HangingRoadwaySignModel model;
    public Font font;

    public GreenHangingRoadwaySignRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new HangingRoadwaySignModel(ctx.bakeLayer(HangingRoadwaySignModel.DEFAULT_MODEL_LAYER_LOCATION));
        this.font = ctx.getFont();
    }

    public void render(GreenHangingRoadwaySign sign, float partialTicks, PoseStack poseStack, MultiBufferSource mbs, int packedLight, int packedColor) {
        VertexConsumer vc = mbs.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)"thingamajigslongroads:textures/entity/hanging_roadway_sign.png")));
        poseStack.pushPose();
        poseStack.translate(0.5, 0.9375, 0.5);
        poseStack.translate(0.0f, -0.3125f, 0.0f);
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.scale(1.0f, -1.0f, -1.0f);
        if (sign.getBlockState().getBlock() instanceof CeilingHangingSignBlock) {
            if (((Boolean)sign.getBlockState().getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                this.model.doublepole.visible = false;
                this.model.centeredpole.visible = true;
            } else {
                this.model.doublepole.visible = true;
                this.model.centeredpole.visible = false;
            }
            this.model.sidepole.visible = false;
            float angle = sign.yAngle;
            poseStack.mulPose(new Quaternionf().rotateY(angle));
        } else {
            this.model.doublepole.visible = false;
            this.model.centeredpole.visible = false;
            this.model.sidepole.visible = true;
            if (sign.getBlockState().is(TLRBlocks.GREEN_WALL_HANGING_SIGN)) {
                if (sign.getBlockState().getValue((Property)GreenHangingWallSignBlock.FACING) == Direction.NORTH) {
                    poseStack.mulPose(new Quaternionf().rotateY(3.15f));
                } else if (sign.getBlockState().getValue((Property)GreenHangingWallSignBlock.FACING) == Direction.SOUTH) {
                    poseStack.mulPose(new Quaternionf().rotateY(3.14f));
                } else if (sign.getBlockState().getValue((Property)GreenHangingWallSignBlock.FACING) == Direction.EAST) {
                    poseStack.mulPose(new Quaternionf().rotateY(1.57f));
                } else if (sign.getBlockState().getValue((Property)GreenHangingWallSignBlock.FACING) == Direction.WEST) {
                    poseStack.mulPose(new Quaternionf().rotateY(-1.57f));
                }
            }
        }
        this.model.main.render(poseStack, vc, packedLight, packedColor);
        this.renderTextOnSign(sign, sign.getBlockPos(), sign.getFrontText(), poseStack, mbs, packedLight, sign.getTextLineHeight(), sign.getMaxTextLineWidth(), true);
        this.renderTextOnSign(sign, sign.getBlockPos(), sign.getBackText(), poseStack, mbs, packedLight, sign.getTextLineHeight(), sign.getMaxTextLineWidth(), false);
        poseStack.popPose();
    }

    public void renderTextOnSign(GreenHangingRoadwaySign sign, BlockPos p_389704_, SignText signText, PoseStack poseStack, MultiBufferSource p_389505_, int p_389571_, int p_389500_, int p_389640_, boolean bool) {
        int l;
        boolean flag;
        int k;
        int j;
        poseStack.pushPose();
        if (!bool) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        float scaleOfText = 0.0135f;
        poseStack.translate(new Vec3(0.0, (double)1.2f, (double)0.073f));
        poseStack.scale(-scaleOfText, scaleOfText, -scaleOfText);
        int textColor = signText.getColor().getTextColor();
        int i = 0;
        if (textColor == DyeColor.BLACK.getTextColor() && signText.hasGlowingText()) {
            i = -988212;
        } else {
            j = (int)((double)ARGB.red((int)textColor) * 0.4);
            int k2 = (int)((double)ARGB.green((int)textColor) * 0.4);
            int l2 = (int)((double)ARGB.blue((int)textColor) * 0.4);
            i = ARGB.color((int)0, (int)j, (int)k2, (int)l2);
        }
        j = 4 * p_389500_ / 2;
        FormattedCharSequence[] aformattedcharsequence = signText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), component -> {
            List list = this.font.split((FormattedText)component, p_389640_);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        if (signText.hasGlowingText()) {
            k = signText.getColor().getTextColor();
            flag = GreenHangingRoadwaySignRenderer.outline(p_389704_, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = p_389571_;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f = -this.font.width(formattedcharsequence) / 2;
            if (flag) {
                this.font.drawInBatch8xOutline(formattedcharsequence, f, (float)(i1 * p_389500_ - j), k, i, poseStack.last().pose(), p_389505_, l);
                continue;
            }
            this.font.drawInBatch(formattedcharsequence, f, (float)(i1 * p_389500_ - j), k, false, poseStack.last().pose(), p_389505_, Font.DisplayMode.POLYGON_OFFSET, 0, l);
        }
        poseStack.popPose();
    }

    public static boolean outline(BlockPos pos, int color) {
        if (color == DyeColor.BLACK.getTextColor()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        if (localplayer != null && minecraft.options.getCameraType().isFirstPerson() && localplayer.isScoping()) {
            return true;
        }
        Entity entity = minecraft.getCameraEntity();
        return entity != null && entity.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }
}

