/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rk.longroads.ThingamajigsLongRoads;
import net.rk.longroads.entity.blockentity.TLRBlockEntity;
import net.rk.longroads.entity.blockentity.custom.DynamicRoadSignBE;
import org.jetbrains.annotations.Nullable;

public class DynamicRoadSignBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<DynamicRoadSignBlock> CODEC = DynamicRoadSignBlock.simpleCodec(DynamicRoadSignBlock::new);
    public static final VoxelShape NORTHSOUTH = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final VoxelShape EASTWEST = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public DynamicRoadSignBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.LANTERN).pushReaction(PushReaction.BLOCK).strength(1.0f, 20.0f).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigslongroads.road_sign.desc").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigslongroads.road_sign.desc_xtra").withStyle(ChatFormatting.GREEN));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: 
            case SOUTH: {
                return NORTHSOUTH;
            }
            case EAST: 
            case WEST: {
                return EASTWEST;
            }
        }
        return Shapes.block();
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (ThingamajigsLongRoads.badFileAccessFlag) {
            level.removeBlock(pos, false);
        }
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DynamicRoadSignBE(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level lvl, BlockState bs, BlockEntityType<T> bet) {
        return DynamicRoadSignBlock.createTickerHelper(bet, TLRBlockEntity.DYNAMIC_ROAD_SIGN_BE.get(), (BlockEntityTicker)(lvl.isClientSide ? DynamicRoadSignBE::clientTick : DynamicRoadSignBE::serverTick));
    }
}

