/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.rk.longroads.datagen.TLRBlockTag;
import net.rk.longroads.datagen.TLRItemModel;
import net.rk.longroads.datagen.TLRItemTag;
import net.rk.longroads.datagen.TLRLoot;
import net.rk.longroads.datagen.TLRRecipe;

@EventBusSubscriber(modid="thingamajigslongroads", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(TLRLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        event.getGenerator().addProvider(event.includeClient(), (DataProvider)new TLRItemModel(packOutput, event.getExistingFileHelper()));
        TLRBlockTag blockTags = new TLRBlockTag(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new TLRItemTag(packOutput, lookupProvider, blockTags.contentsGetter(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new TLRRecipe(packOutput, lookupProvider));
    }
}

