/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.entity.blockentity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.rk.longroads.ThingamajigsLongRoads;
import net.rk.longroads.entity.blockentity.TLRBlockEntity;
import org.jetbrains.annotations.Nullable;

public class DynamicRoadSignBE
extends BlockEntity {
    BlockPos bp;
    public float yAngle = 0.0f;
    public int ticks;
    public int signType = 0;
    public String signTexture = "-1";

    public DynamicRoadSignBE(BlockPos pos, BlockState blockState) {
        super(TLRBlockEntity.DYNAMIC_ROAD_SIGN_BE.get(), pos, blockState);
        this.bp = pos;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lp) {
        CompoundTag ct = new CompoundTag();
        this.saveAdditional(ct, lp);
        return ct;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }

    public void updateBlock() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState bs2 = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), bs2, bs2, 3);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider slp) {
        super.saveAdditional(pTag, slp);
        pTag.putFloat("y_angle", this.yAngle);
        pTag.putString("sign_texture", this.signTexture);
        pTag.putInt("sign_type", this.signType);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider lp) {
        this.yAngle = pTag.getFloat("y_angle");
        this.signTexture = pTag.getString("sign_texture");
        this.signType = pTag.getInt("sign_type");
    }

    public static void serverTick(Level slvl, BlockPos sbp, BlockState sbs, DynamicRoadSignBE rrcbe) {
        if (ThingamajigsLongRoads.badFileAccessFlag) {
            slvl.removeBlock(sbp, false);
            return;
        }
        ++rrcbe.ticks;
        if (rrcbe.ticks >= Short.MAX_VALUE) {
            rrcbe.ticks = 0;
        }
    }

    public static void clientTick(Level lvl, BlockPos bp, BlockState bs, DynamicRoadSignBE rrcbe) {
        if (ThingamajigsLongRoads.badFileAccessFlag) {
            return;
        }
        ++rrcbe.ticks;
        if (rrcbe.ticks >= Short.MAX_VALUE) {
            rrcbe.ticks = 0;
        }
    }
}

