/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.block.custom.Asphalt;
import net.rk.longroads.block.custom.AsphaltSlab;
import net.rk.longroads.block.custom.MarkedAsphalt;
import net.rk.longroads.block.custom.RotatingSlab;
import net.rk.longroads.block.custom.YellowRoadMarking;
import net.rk.longroads.item.TLRDataComponents;
import net.rk.longroads.item.legacyruns.ChangeTypeYellow;

public class YellowPaintBrush
extends Item {
    public String currentName = "No Pattern Selected";

    public void typeToName(int type) {
        switch (type) {
            case 0: {
                this.currentName = "Full Cover";
                break;
            }
            case 1: {
                this.currentName = "Thin Corner Dot";
                break;
            }
            case 2: {
                this.currentName = "Center Double Line Turn";
                break;
            }
            case 3: {
                this.currentName = "Center Double Line";
                break;
            }
            case 4: {
                this.currentName = "Center Single Corner";
                break;
            }
            case 5: {
                this.currentName = "Center Single Line";
                break;
            }
            case 6: {
                this.currentName = "Center Dashed Single Line";
                break;
            }
            case 7: {
                this.currentName = "Thick Parking Line";
                break;
            }
            case 8: {
                this.currentName = "Thin Corner";
                break;
            }
            case 9: {
                this.currentName = "Thin Parking Line";
                break;
            }
            case 10: {
                this.currentName = "Short Line";
                break;
            }
            case 11: {
                this.currentName = "Short 'T'";
                break;
            }
            case 12: {
                this.currentName = "Plus";
                break;
            }
            case 13: {
                this.currentName = "Square";
                break;
            }
            case 14: {
                this.currentName = "Center 'T'";
                break;
            }
            case 15: {
                this.currentName = "Long 'T'";
                break;
            }
            case 16: {
                this.currentName = "yellow marking";
                break;
            }
            default: {
                this.currentName = "undefined";
            }
        }
    }

    public YellowPaintBrush(Item.Properties p) {
        super(p.durability(3000).stacksTo(1));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        if (!pContext.getLevel().isClientSide()) {
            Level levelAccessor = pContext.getLevel();
            Level level = pContext.getLevel();
            BlockPos positionClicked = pContext.getClickedPos();
            Block blockClicked = level.getBlockState(positionClicked).getBlock();
            ItemStack stack = pContext.getItemInHand();
            Block marking = (Block)TLRBlocks.YELLOW_ROAD_MARKING.get();
            Player ply = pContext.getPlayer();
            int marking_type = 0;
            if (blockClicked instanceof AsphaltSlab && !ply.isShiftKeyDown()) {
                BlockState oldState = pContext.getLevel().getBlockState(pContext.getClickedPos());
                BlockState paintAsp = ((Block)TLRBlocks.YELLOW_DT_ASPHALT_SLAB.get()).defaultBlockState();
                if (ply.getItemInHand(ply.getUsedItemHand()).has((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get())) {
                    int type = (Integer)ply.getItemInHand(ply.getUsedItemHand()).get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get());
                    SlabType top = SlabType.TOP;
                    SlabType bottom = SlabType.BOTTOM;
                    SlabType d = SlabType.DOUBLE;
                    SlabType slab = top;
                    if (oldState.getValue((Property)SlabBlock.TYPE) == top) {
                        slab = top;
                    } else if (oldState.getValue((Property)SlabBlock.TYPE) == bottom) {
                        slab = bottom;
                    } else if (oldState.getValue((Property)SlabBlock.TYPE) == d) {
                        slab = d;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_SLAB.get()) {
                        if (type == 2) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_DT_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 3) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_D_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 9) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_PARKING_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_OK_SLAB.get()) {
                        if (type == 2) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_DT_OK_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 3) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_D_OK_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 9) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_PARKING_OK_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_MEDIOCRE_SLAB.get()) {
                        if (type == 2) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_DT_MEDIOCRE_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 3) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_D_MEDIOCRE_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 9) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_PARKING_MEDIOCRE_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                    if (blockClicked == TLRBlocks.ASPHALT_OLD_SLAB.get()) {
                        if (type == 2) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_DT_OLD_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 3) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_D_OLD_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        if (type == 9) {
                            paintAsp = ((Block)TLRBlocks.YELLOW_PARKING_OLD_ASPHALT_SLAB.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)RotatingSlab.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)RotatingSlab.TYPE, (Comparable)slab), 3);
                            return this.finished(ply);
                        }
                        return InteractionResult.PASS;
                    }
                }
            }
            if (blockClicked instanceof Asphalt && !ply.isShiftKeyDown()) {
                BlockState paintAsp = ((Block)TLRBlocks.YELLOW_PARKING_ASPHALT.get()).defaultBlockState();
                if (ply.getItemInHand(ply.getUsedItemHand()).has((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get())) {
                    int type = (Integer)ply.getItemInHand(ply.getUsedItemHand()).get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get());
                    int age = 0;
                    boolean notValid = false;
                    if (blockClicked == TLRBlocks.ASPHALT.get()) {
                        age = 0;
                    } else if (blockClicked == TLRBlocks.ASPHALT_OK.get()) {
                        age = 1;
                    } else if (blockClicked == TLRBlocks.ASPHALT_MEDIOCRE.get()) {
                        age = 2;
                    } else if (blockClicked == TLRBlocks.ASPHALT_OLD.get()) {
                        age = 3;
                    } else {
                        notValid = true;
                    }
                    if (!notValid) {
                        if (type == 2) {
                            paintAsp = ((Block)TLRBlocks.DOUBLE_CORNER_YELLOW_ASPHALT.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)MarkedAsphalt.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)MarkedAsphalt.AGE, (Comparable)Integer.valueOf(age)), 3);
                            return this.finished(ply);
                        }
                        if (type == 3) {
                            paintAsp = ((Block)TLRBlocks.DOUBLE_YELLOW_ASPHALT.get()).defaultBlockState();
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)MarkedAsphalt.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)MarkedAsphalt.AGE, (Comparable)Integer.valueOf(age)), 3);
                            return this.finished(ply);
                        }
                        if (type == 9) {
                            level.setBlock(positionClicked, (BlockState)((BlockState)paintAsp.setValue((Property)MarkedAsphalt.FACING, (Comparable)ply.getDirection().getOpposite())).setValue((Property)MarkedAsphalt.AGE, (Comparable)Integer.valueOf(age)), 3);
                            return this.finished(ply);
                        }
                        notValid = true;
                    }
                }
            }
            if (pContext.getHand() == InteractionHand.MAIN_HAND) {
                CompoundTag tag = new CompoundTag();
                if (pContext.getPlayer().isShiftKeyDown()) {
                    if (stack.has((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get())) {
                        this.increaseType(stack);
                        marking_type = (Integer)stack.get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get());
                        level.playSound(null, positionClicked, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        stack.set((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get(), (Object)0);
                        level.playSound(null, positionClicked, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    if (stack.has((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get())) {
                        marking_type = (Integer)stack.get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get());
                    }
                    ChangeTypeYellow.execute((LevelAccessor)levelAccessor, pContext.getClickedPos().getX(), pContext.getClickedPos().getY(), pContext.getClickedPos().getZ(), (Entity)pContext.getPlayer(), stack, marking_type);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult finished(Player ply) {
        ply.swing(ply.getUsedItemHand());
        return InteractionResult.CONSUME;
    }

    private void increaseType(ItemStack stack) {
        if (stack.has((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get())) {
            stack.set((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get(), (Object)((Integer)stack.get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get()) + 1));
            if ((Integer)stack.get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get()) >= YellowRoadMarking.getMaxTypes()) {
                stack.set((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get(), (Object)0);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.has((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get())) {
            this.typeToName((Integer)stack.get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get()));
            tooltipComponents.add((Component)Component.translatable((String)"item.paint_brush.data.pattern_type", (Object[])new Object[]{(int)((Integer)stack.getComponents().get((DataComponentType)TLRDataComponents.ROAD_MARKING_PATTERN.get()))}));
            tooltipComponents.add((Component)Component.literal((String)this.currentName).withStyle(ChatFormatting.GREEN));
        }
    }
}

