/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.logging.Logger;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rk.longroads.entity.blockentity.custom.DynamicRoadSignBE;
import net.rk.longroads.entity.blockentity.model.DynamicSignModel;

public class DynamicRoadSignBERenderer
implements BlockEntityRenderer<DynamicRoadSignBE> {
    public DynamicSignModel dsmodel;
    private boolean invalidPath = false;

    public DynamicRoadSignBERenderer(BlockEntityRendererProvider.Context ctx) {
        this.dsmodel = new DynamicSignModel(ctx.bakeLayer(DynamicSignModel.SIGN_TEXTURE_LOCATION));
    }

    public void render(DynamicRoadSignBE dynamicSignBE, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        block7: {
            String str;
            if (!ResourceLocation.isValidPath((String)dynamicSignBE.signTexture)) {
                str = "thingamajigslongroads:textures/entity/signs/sign_error.png";
                this.invalidPath = true;
            } else {
                this.invalidPath = false;
            }
            try {
                if (dynamicSignBE.signTexture.equals("-1")) {
                    str = "thingamajigslongroads:textures/entity/signs/sign_error.png";
                } else {
                    if (this.invalidPath) {
                        return;
                    }
                    str = dynamicSignBE.signTexture;
                }
                poseStack.pushPose();
                VertexConsumer vc = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)str)));
                poseStack.translate(0.5f, -0.5f, 0.5f);
                this.dsmodel.setupAnim(dynamicSignBE);
                this.dsmodel.renderToBuffer(poseStack, vc, i, i1);
                poseStack.popPose();
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().warning("DynamicRoadSignBE experienced rendering issues. Removing block.");
                if (!(dynamicSignBE.getLevel() instanceof ServerLevel)) break block7;
                dynamicSignBE.getLevel().destroyBlock(dynamicSignBE.getBlockPos(), true);
            }
        }
    }

    public int getViewDistance() {
        return 54;
    }

    public AABB getRenderBoundingBox(DynamicRoadSignBE blockEntity) {
        return new AABB((double)(blockEntity.getBlockPos().getX() - 1), (double)blockEntity.getBlockPos().getY(), (double)(blockEntity.getBlockPos().getZ() - 1), (double)(blockEntity.getBlockPos().getX() + 1), (double)(blockEntity.getBlockPos().getY() + 1), (double)(blockEntity.getBlockPos().getZ() + 1));
    }

    public boolean shouldRender(DynamicRoadSignBE be, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)be.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)vec3.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public boolean shouldRenderOffScreen(DynamicRoadSignBE blockEntity) {
        return false;
    }
}

