/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads;

import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.rk.longroads.entity.blockentity.TLRBlockEntity;
import net.rk.longroads.entity.blockentity.model.DynamicDoubleTallSignModel;
import net.rk.longroads.entity.blockentity.model.DynamicRectangleSignModel;
import net.rk.longroads.entity.blockentity.model.DynamicSignModel;
import net.rk.longroads.menu.TLRMenu;
import net.rk.longroads.render.DynamicRoadSignBERenderer;
import net.rk.longroads.screen.DynamicRoadSignScreen;
import net.rk.longroads.util.Utilities;

@Mod(value="thingamajigslongroads", dist={Dist.CLIENT})
public class LongRoadsClient {
    public LongRoadsClient(IEventBus bus) {
        TLRClientEvents.doStuff(bus);
    }

    public static class TLRClientEvents {
        private static void doStuff(IEventBus modEventBus) {
            modEventBus.addListener(TLRClientEvents::clientSetup);
            modEventBus.addListener(TLRClientEvents::setupBlockEntityRenderers);
            modEventBus.addListener(TLRClientEvents::layerSetup);
            modEventBus.addListener(TLRClientEvents::setupMenuTypes);
        }

        public static void clientSetup(FMLClientSetupEvent event) {
            WoodType.register((WoodType)Utilities.GREEN_ROADWAY_WOOD);
            Sheets.addWoodType((WoodType)Utilities.GREEN_ROADWAY_WOOD);
            WoodType.register((WoodType)Utilities.RED_ROADWAY_WOOD);
            Sheets.addWoodType((WoodType)Utilities.RED_ROADWAY_WOOD);
            WoodType.register((WoodType)Utilities.BLUE_ROADWAY_WOOD);
            Sheets.addWoodType((WoodType)Utilities.BLUE_ROADWAY_WOOD);
            WoodType.register((WoodType)Utilities.BROWN_ROADWAY_WOOD);
            Sheets.addWoodType((WoodType)Utilities.BROWN_ROADWAY_WOOD);
        }

        public static void setupBlockEntityRenderers(FMLClientSetupEvent event) {
            BlockEntityRenderers.register(TLRBlockEntity.GREEN_ROADWAY_SIGN.get(), SignRenderer::new);
            BlockEntityRenderers.register(TLRBlockEntity.RED_ROADWAY_SIGN.get(), SignRenderer::new);
            BlockEntityRenderers.register(TLRBlockEntity.BLUE_ROADWAY_SIGN.get(), SignRenderer::new);
            BlockEntityRenderers.register(TLRBlockEntity.BROWN_ROADWAY_SIGN.get(), SignRenderer::new);
            BlockEntityRenderers.register(TLRBlockEntity.GREEN_HANGING_ROADWAY_SIGN.get(), HangingSignRenderer::new);
            BlockEntityRenderers.register(TLRBlockEntity.DYNAMIC_ROAD_SIGN_BE.get(), DynamicRoadSignBERenderer::new);
        }

        public static void layerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DynamicSignModel.SIGN_TEXTURE_LOCATION, DynamicSignModel::createBodyLayer);
            event.registerLayerDefinition(DynamicRectangleSignModel.RECTANGLE_SIGN_TEXTURE_LOCATION, DynamicRectangleSignModel::createBodyLayer);
            event.registerLayerDefinition(DynamicDoubleTallSignModel.DOUBLE_TALL_SIGN_TEXTURE_LOCATION, DynamicDoubleTallSignModel::createBodyLayer);
        }

        public static void setupMenuTypes(RegisterMenuScreensEvent event) {
            event.register((MenuType)TLRMenu.SIGN_MENU.get(), DynamicRoadSignScreen::new);
        }
    }
}

