/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads;

import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.rk.longroads.block.TLRBlocks;
import net.rk.longroads.entity.blockentity.TLRBlockEntity;
import net.rk.longroads.item.TLRDataComponents;
import net.rk.longroads.item.TLRItems;
import net.rk.longroads.menu.TLRMenu;
import net.rk.longroads.network.TLRHandler;
import net.rk.longroads.registries.SignType;
import net.rk.longroads.registries.SignTypeBootstrap;
import net.rk.longroads.registries.TLRRegistries;
import net.rk.thingamajigs.Thingamajigs;
import org.slf4j.Logger;

@Mod(value="thingamajigslongroads")
public class ThingamajigsLongRoads {
    public static final String MODID = "thingamajigslongroads";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CMT_TLR = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"thingamajigslongroads");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TLR_TAB = CMT_TLR.register("trr_main_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.thingamajigslongroads")).withTabsBefore(new ResourceKey[]{Thingamajigs.MAIN_CTAB.getKey()}).icon(() -> ((Item)TLRItems.GREEN_HANGING_ROADWAY_SIGN_ITEM.get()).getDefaultInstance()).backgroundTexture(ResourceLocation.fromNamespaceAndPath((String)"thingamajigs", (String)"textures/gui/thingamajigsitems.png")).build());
    public static boolean werok = false;

    public ThingamajigsLongRoads(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        if (ModList.get().isLoaded("thingamajigs")) {
            werok = true;
        }
        modEventBus.addListener(TLRHandler::register);
        modEventBus.addListener(this::registerDatapackRegistries);
        modEventBus.addListener(this::onGatherData);
        TLRMenu.MENU_TYPES.register(modEventBus);
        TLRBlocks.BLOCKS.register(modEventBus);
        TLRItems.ITEMS.register(modEventBus);
        TLRBlockEntity.register(modEventBus);
        CMT_TLR.register(modEventBus);
        TLRDataComponents.COMPONENTS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == TLR_TAB.getKey()) {
            event.accept(TLRItems.PAINT_BRUSH);
            event.accept(TLRItems.WHITE_PAINT_BRUSH);
            event.accept(TLRItems.YELLOW_PAINT_BRUSH);
            event.accept(TLRItems.BLUE_PAINT_BRUSH);
            event.accept(TLRItems.SCRAPE_TOOL);
            event.accept(TLRItems.DYNAMIC_ROAD_SIGN);
            event.accept(TLRItems.DYNAMIC_STRAIGHT_ROAD_SIGN);
            event.accept(TLRItems.DYNAMIC_THREE_WAY_ROAD_SIGN);
            event.accept(TLRItems.DYNAMIC_VERTICAL_REDSTONE_ROAD_SIGN);
            event.accept(TLRItems.GREEN_ROADWAY_SIGN_ITEM);
            event.accept(TLRItems.GREEN_HANGING_ROADWAY_SIGN_ITEM);
            event.accept(TLRItems.RED_ROADWAY_SIGN_ITEM);
            event.accept(TLRItems.BLUE_ROADWAY_SIGN_ITEM);
            event.accept(TLRItems.BROWN_ROADWAY_SIGN_ITEM);
            event.accept((ItemLike)TLRBlocks.ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.ASPHALT_OK.asItem());
            event.accept((ItemLike)TLRBlocks.ASPHALT_OK_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.ASPHALT_MEDIOCRE.asItem());
            event.accept((ItemLike)TLRBlocks.ASPHALT_MEDIOCRE_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.ASPHALT_OLD.asItem());
            event.accept((ItemLike)TLRBlocks.ASPHALT_OLD_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.DOUBLE_WHITE_ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.DOUBLE_CORNER_WHITE_ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_PARKING_ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_PARKING_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_PARKING_OK_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_PARKING_MEDIOCRE_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_PARKING_OLD_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_D_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_D_OK_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_D_MEDIOCRE_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_D_OLD_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_DT_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_DT_OK_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_DT_MEDIOCRE_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.WHITE_DT_OLD_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.DOUBLE_YELLOW_ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.DOUBLE_CORNER_YELLOW_ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_OK_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_MEDIOCRE_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_PARKING_OLD_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_D_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_D_OK_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_D_MEDIOCRE_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_D_OLD_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_DT_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_DT_OK_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_DT_MEDIOCRE_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.YELLOW_DT_OLD_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.BLUE_PARKING_ASPHALT.asItem());
            event.accept((ItemLike)TLRBlocks.BLUE_PARKING_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.BLUE_PARKING_OK_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.BLUE_PARKING_MEDIOCRE_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.BLUE_PARKING_OLD_ASPHALT_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.VERTICAL_REDSTONE_SIDEWALK.asItem());
            event.accept((ItemLike)TLRBlocks.SIDEWALK.asItem());
            event.accept((ItemLike)TLRBlocks.SIDEWALK_BLOCKED.asItem());
            event.accept((ItemLike)TLRBlocks.SIDEWALK_SECTIONED.asItem());
            event.accept((ItemLike)TLRBlocks.SIDEWALK_CRACKED.asItem());
            event.accept((ItemLike)TLRBlocks.SIDEWALK_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.BLOCKED_SIDEWALK_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.SECTIONED_SIDEWALK_SLAB.asItem());
            event.accept((ItemLike)TLRBlocks.CRACKED_SIDEWALK_SLAB.asItem());
        }
    }

    @SubscribeEvent
    public void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(TLRRegistries.SIGN_TYPE, SignType.CODEC, SignType.CODEC);
    }

    @SubscribeEvent
    public void onGatherData(GatherDataEvent event) {
        PackOutput packOutput = event.getGenerator().getPackOutput();
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), new RegistrySetBuilder().add(TLRRegistries.SIGN_TYPE, SignTypeBootstrap::bootstrap), Set.of(MODID)));
    }
}

