/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.block.custom;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class RotatingSlab
extends SlabBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public RotatingSlab(BlockBehaviour.Properties p) {
        super(p);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext bpc) {
        BlockPos blockpos = bpc.getClickedPos();
        BlockState blockstate = bpc.getLevel().getBlockState(blockpos);
        Player ply = bpc.getPlayer();
        if (blockstate.is((Block)this)) {
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)ply.getDirection().getOpposite());
        }
        FluidState fluidstate = bpc.getLevel().getFluidState(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        Direction direction = bpc.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && bpc.getClickLocation().y - (double)blockpos.getY() > 0.5) ? (BlockState)blockstate1.setValue((Property)FACING, (Comparable)ply.getDirection().getOpposite()) : (BlockState)((BlockState)blockstate1.setValue((Property)TYPE, (Comparable)SlabType.TOP)).setValue((Property)FACING, (Comparable)ply.getDirection().getOpposite());
    }
}

