/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.entity.blockentity.custom;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.rk.longroads.entity.blockentity.TLRBlockEntity;
import net.rk.longroads.registries.SignType;
import net.rk.longroads.registries.TLRRegistries;
import net.rk.longroads.util.SignTypeHolderObject;
import org.jetbrains.annotations.Nullable;

public class DynamicRoadSignBE
extends BlockEntity {
    BlockPos bp;
    public float yAngle = 0.0f;
    public int ticks;
    public String signTexture = "thingamajigslongroads:textures/entity/signs/sign_error.png";
    public String modelType = "square";
    public final String fallbackSignTexture = "thingamajigslongroads:textures/entity/signs/sign_error.png";
    public SignTypeHolderObject holderList;
    public int indexId;

    public void updateSign() {
        List list = this.level.registryAccess().registryOrThrow(TLRRegistries.SIGN_TYPE).stream().toList();
        try {
            this.holderList = new SignTypeHolderObject.Builder().add(new SignTypeHolderObject.HolderSignType((Holder<SignType>)Holder.direct((Object)((SignType)list.get(this.indexId))))).buildSignTypeHolderBuilder();
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Something went wrong when trying to apply a change to SignType in DynamicRoadSignBE! ERR: {}", (Object)e.getMessage());
            this.holderList = SignTypeHolderObject.makeDefaultSign(this.level);
        }
        String tempTexture = "thingamajigslongroads:textures/entity/signs/" + this.holderList.typesHolderObjectList().get(0).getSignType().assetId().getPath() + ".png";
        this.signTexture = tempTexture;
        this.modelType = this.holderList.typesHolderObjectList().get(0).getSignType().signModeltype();
    }

    public DynamicRoadSignBE(BlockPos pos, BlockState blockState) {
        super(TLRBlockEntity.DYNAMIC_ROAD_SIGN_BE.get(), pos, blockState);
        this.bp = pos;
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && this.holderList == null) {
            this.holderList = SignTypeHolderObject.makeDefaultSign(this.level);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lp) {
        return this.saveWithoutMetadata(lp);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }

    public void updateBlock() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState bs2 = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), bs2, bs2, 3);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider slp) {
        super.saveAdditional(pTag, slp);
        pTag.putFloat("y_angle", this.yAngle);
        pTag.putString("sign_texture", this.signTexture);
        pTag.putString("model_type", this.modelType);
        if (this.holderList != null) {
            pTag.put("sign_types", (Tag)SignTypeHolderObject.CODEC.encodeStart((DynamicOps)slp.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.holderList).getOrThrow());
        } else {
            this.holderList = SignTypeHolderObject.makeDefaultSign(this.level);
            pTag.put("sign_types", (Tag)SignTypeHolderObject.CODEC.encodeStart((DynamicOps)slp.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.holderList).getOrThrow());
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider lp) {
        this.yAngle = pTag.getFloat("y_angle");
        if (pTag.contains("sign_texture")) {
            this.signTexture = pTag.getString("sign_texture");
        }
        if (pTag.contains("model_type")) {
            this.modelType = pTag.getString("model_type");
        }
        if (pTag.contains("sign_types")) {
            SignTypeHolderObject.CODEC.parse((DynamicOps)lp.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)pTag.get("sign_types")).resultOrPartial(str -> LogUtils.getLogger().error("Failed to parse sign types: '{}'", str)).ifPresent(str -> {
                this.holderList = str;
            });
        }
    }

    public static void serverTick(Level slvl, BlockPos sbp, BlockState sbs, DynamicRoadSignBE rrcbe) {
        ++rrcbe.ticks;
        if (rrcbe.ticks >= Short.MAX_VALUE) {
            rrcbe.ticks = 0;
        }
    }

    public static void clientTick(Level lvl, BlockPos bp, BlockState bs, DynamicRoadSignBE rrcbe) {
        ++rrcbe.ticks;
        if (rrcbe.ticks >= Short.MAX_VALUE) {
            rrcbe.ticks = 0;
        }
    }
}

