/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.menu;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.rk.longroads.entity.blockentity.custom.DynamicRoadSignBE;
import net.rk.longroads.menu.TLRMenu;
import net.rk.longroads.registries.SignType;
import net.rk.longroads.registries.TLRRegistries;
import org.jetbrains.annotations.Nullable;

public class DynamicSignMenu
extends AbstractContainerMenu {
    public Level level;
    public Player player;
    public DynamicRoadSignBE be;
    public BlockPos pos;
    public final DataSlot signTypeData = DataSlot.standalone();
    public static List<SignType> signTypes;
    public int indexSelected;

    protected DynamicSignMenu(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    public int getIndex() {
        return this.indexSelected;
    }

    public DynamicSignMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this((MenuType)TLRMenu.SIGN_MENU.get(), id);
        this.player = inv.player;
        this.level = this.player.level();
        if (extraData != null) {
            BlockPos pos1;
            this.pos = pos1 = extraData.readBlockPos();
            if (this.level.getBlockEntity(this.pos) instanceof DynamicRoadSignBE) {
                this.be = (DynamicRoadSignBE)this.level.getBlockEntity(this.pos);
            }
        }
        this.addDataSlot(this.signTypeData);
        signTypes = this.level.registryAccess().registryOrThrow(TLRRegistries.SIGN_TYPE).stream().toList();
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DynamicSignMenu.this.be.indexId & 0xFFFF;
            }

            public void set(int pValue) {
                DynamicSignMenu.this.indexSelected = DynamicSignMenu.this.indexSelected & 0xFFFF0000 | pValue & 0xFFFF;
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return null;
    }

    public boolean stillValid(Player player) {
        return player.level().getBlockEntity(this.be.getBlockPos()) instanceof DynamicRoadSignBE;
    }

    public boolean clickedSignTypeSelectorButton(Player player, int id) {
        if (id >= 0) {
            if (id < signTypes.size()) {
                return true;
            }
        }
        return false;
    }
}

