/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.network.packet;

import java.util.logging.Logger;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.rk.longroads.entity.blockentity.custom.DynamicRoadSignBE;
import net.rk.longroads.network.record.DynamicSignPayload;

public class DynamicSignPacket {
    public static final DynamicSignPacket INSTANCE = new DynamicSignPacket();

    public static DynamicSignPacket get() {
        return INSTANCE;
    }

    public void handle(DynamicSignPayload payload, IPayloadContext context) {
        Player ply = context.player();
        Level lvl = ply.level();
        if (ply == null) {
            return;
        }
        if (!lvl.hasChunk(SectionPos.blockToSectionCoord((int)payload.bp().getX()), SectionPos.blockToSectionCoord((int)payload.bp().getZ()))) {
            return;
        }
        DynamicRoadSignBE dsbe = (DynamicRoadSignBE)lvl.getBlockEntity(payload.bp());
        if (dsbe == null) {
            Logger.getAnonymousLogger().warning("Dynamic Sign BE at: " + String.valueOf(payload.bp()) + " is null! This is not normal!");
            return;
        }
        if (payload.updateSelf()) {
            dsbe.indexId = payload.id();
            dsbe.updateSign();
            dsbe.updateBlock();
        } else {
            dsbe.yAngle = payload.rotation();
            dsbe.updateBlock();
        }
    }
}

