/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rk.longroads.entity.blockentity.custom.DynamicRoadSignBE;
import net.rk.longroads.entity.blockentity.model.DynamicDoubleTallSignModel;
import net.rk.longroads.entity.blockentity.model.DynamicRectangleSignModel;
import net.rk.longroads.entity.blockentity.model.DynamicSignModel;
import net.rk.longroads.util.Utilities;

public class DynamicRoadSignBERenderer
implements BlockEntityRenderer<DynamicRoadSignBE> {
    public DynamicSignModel dsmodel;
    public DynamicRectangleSignModel dsrectmodel;
    public DynamicDoubleTallSignModel dsdtmodel;

    public DynamicRoadSignBERenderer(BlockEntityRendererProvider.Context ctx) {
        this.dsmodel = new DynamicSignModel(ctx.bakeLayer(DynamicSignModel.SIGN_TEXTURE_LOCATION));
        this.dsrectmodel = new DynamicRectangleSignModel(ctx.bakeLayer(DynamicRectangleSignModel.RECTANGLE_SIGN_TEXTURE_LOCATION));
        this.dsdtmodel = new DynamicDoubleTallSignModel(ctx.bakeLayer(DynamicDoubleTallSignModel.DOUBLE_TALL_SIGN_TEXTURE_LOCATION));
    }

    public void render(DynamicRoadSignBE dynamicSignBE, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        String str;
        poseStack.pushPose();
        if (ResourceLocation.tryParse((String)dynamicSignBE.signTexture) != null) {
            str = dynamicSignBE.signTexture;
        } else {
            String string = dynamicSignBE.modelType;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"double_square", "rectangle"}, (Object)string, n)) {
                case 0: {
                    str = "thingamajigslongroads:textures/entity/signs/big_sign_error.png";
                    break;
                }
                case 1: {
                    str = "thingamajigslongroads:textures/entity/signs/rect_sign_error.png";
                    break;
                }
                default: {
                    str = dynamicSignBE.fallbackSignTexture;
                }
            }
        }
        VertexConsumer vc = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)str)));
        poseStack.translate(0.5f, -0.5f, 0.5f);
        if (Objects.equals(dynamicSignBE.modelType, Utilities.SignModelTypes.SQUARE.getModelTypeName())) {
            this.dsmodel.setupAnim(dynamicSignBE);
            this.dsmodel.renderToBuffer(poseStack, vc, i, i1);
        } else if (Objects.equals(dynamicSignBE.modelType, Utilities.SignModelTypes.DOUBLE_SQUARE.getModelTypeName())) {
            this.dsdtmodel.setupAnim(dynamicSignBE);
            this.dsdtmodel.renderToBuffer(poseStack, vc, i, i1);
        } else if (Objects.equals(dynamicSignBE.modelType, Utilities.SignModelTypes.RECTANGLE.getModelTypeName())) {
            this.dsrectmodel.setupAnim(dynamicSignBE);
            this.dsrectmodel.renderToBuffer(poseStack, vc, i, i1);
        } else {
            this.dsmodel.setupAnim(dynamicSignBE);
            this.dsmodel.renderToBuffer(poseStack, vc, i, i1);
        }
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 54;
    }

    public AABB getRenderBoundingBox(DynamicRoadSignBE blockEntity) {
        return new AABB((double)(blockEntity.getBlockPos().getX() - 1), (double)blockEntity.getBlockPos().getY(), (double)(blockEntity.getBlockPos().getZ() - 1), (double)(blockEntity.getBlockPos().getX() + 1), (double)(blockEntity.getBlockPos().getY() + 1), (double)(blockEntity.getBlockPos().getZ() + 1));
    }

    public boolean shouldRender(DynamicRoadSignBE be, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)be.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)vec3.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public boolean shouldRenderOffScreen(DynamicRoadSignBE blockEntity) {
        return false;
    }
}

