/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.rk.longroads.menu.DynamicSignMenu;
import net.rk.longroads.network.record.DynamicSignPayload;
import net.rk.longroads.registries.SignType;
import net.rk.longroads.screen.widget.DynamicEditBox;
import net.rk.longroads.util.Utilities;
import net.rk.thingamajigs.screen.widget.RevertedButton;
import net.rk.thingamajigs.xtras.TColors;

public class DynamicRoadSignScreen
extends AbstractContainerScreen<DynamicSignMenu> {
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.parse((String)"thingamajigslongroads:textures/gui/road_sign_bg.png");
    private static final ResourceLocation LIST_BG = ResourceLocation.parse((String)"thingamajigslongroads:textures/gui/road_sign_list_bg.png");
    private RevertedButton decreaseRotation;
    private RevertedButton increaseRotation;
    private RevertedButton roundRotation;
    private EditBox customTextureEdit;
    public boolean scrolling = false;
    public float scrollOffs = 0.0f;
    public int startRow = 0;
    public int listButtonStartX = 184;
    public int listButtonStartY = 96;
    public int listBGX = 183;
    public int listBGY = 94;
    public int scrollerStartX = 241;
    public int scrollerStartY = 95;
    private int buttonSizeX = 14;
    private int buttonSizeY = 14;

    public DynamicRoadSignScreen(DynamicSignMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 320;
        this.imageHeight = 240;
    }

    protected void init() {
        super.init();
        this.setup();
        this.addRenderableWidget((GuiEventListener)this.decreaseRotation);
        this.addRenderableWidget((GuiEventListener)this.increaseRotation);
        this.addRenderableWidget((GuiEventListener)this.roundRotation);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        guiGraphics.blit(BG_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIST_BG);
        guiGraphics.blit(LIST_BG, this.leftPos + this.listBGX, this.topPos + this.listBGY, 0.0f, 0.0f, 71, 60, 71, 60);
        RenderSystem.disableBlend();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 132), (float)(this.topPos + 20), 0.0f);
        guiGraphics.pose().scale(64.0f, 36.0f, 0.0f);
        if (ResourceLocation.tryParse((String)((DynamicSignMenu)this.menu).be.signTexture) == null) {
            BeaconRenderer.renderBeaconBeam((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (ResourceLocation)ResourceLocation.parse((String)((DynamicSignMenu)this.menu).be.fallbackSignTexture), (float)0.0f, (float)2.0f, (long)0L, (int)0, (int)1, (int)TColors.getWhite(), (float)1.0f, (float)0.0f);
        } else {
            BeaconRenderer.renderBeaconBeam((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (ResourceLocation)ResourceLocation.parse((String)((DynamicSignMenu)this.menu).be.signTexture), (float)0.0f, (float)2.0f, (long)0L, (int)0, (int)1, (int)TColors.getWhite(), (float)1.0f, (float)0.0f);
        }
        guiGraphics.pose().popPose();
        int scroll = (int)(41.0f * this.scrollOffs);
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller");
        guiGraphics.blitSprite(resourcelocation, this.leftPos + this.scrollerStartX, this.topPos + this.scrollerStartY + scroll, 12, 15);
        Lighting.setupForFlatItems();
        int j2 = this.leftPos + this.listButtonStartX;
        int k2 = this.topPos + this.listButtonStartY;
        List<SignType> list = DynamicSignMenu.signTypes;
        block0: for (int xLen = 0; xLen < 4; ++xLen) {
            for (int i1 = 0; i1 < 4; ++i1) {
                boolean flag;
                int j1 = xLen + this.startRow;
                int buttonIndex = j1 * 4 + i1;
                if (buttonIndex >= list.size()) break block0;
                int x = j2 + i1 * this.buttonSizeX;
                int y = k2 + xLen * this.buttonSizeY;
                boolean bl = flag = mouseX >= x && mouseY >= y && mouseX < x + this.buttonSizeX && mouseY < y + this.buttonSizeY;
                ResourceLocation buttonSprite = buttonIndex == ((DynamicSignMenu)this.menu).be.indexId ? RevertedButton.LASER_SPRITES.get(true, false) : (flag ? RevertedButton.LASER_SPRITES.get(true, true) : RevertedButton.LASER_SPRITES.get(false, false));
                guiGraphics.blitSprite(buttonSprite, x, y, this.buttonSizeX, this.buttonSizeY);
                if (DynamicSignMenu.signTypes == null) continue;
                ResourceLocation res = ResourceLocation.parse((String)("thingamajigslongroads:textures/entity/signs/" + DynamicSignMenu.signTypes.get(buttonIndex).assetId().getPath() + ".png"));
                if (res == null) {
                    res = ResourceLocation.parse((String)"thingamajigslongroads:textures/entity/signs/sign_error.png");
                }
                if (DynamicSignMenu.signTypes.get(buttonIndex).signModeltype().equals(Utilities.SignModelTypes.SQUARE.getModelTypeName())) {
                    guiGraphics.blit(res, x, y, 0.0f, 0.0f, 14, 14, 32, 32);
                    continue;
                }
                if (DynamicSignMenu.signTypes.get(buttonIndex).signModeltype().equals(Utilities.SignModelTypes.DOUBLE_SQUARE.getModelTypeName())) {
                    guiGraphics.blit(res, x, y, 0.0f, 0.0f, 14, 14, 128, 128);
                    continue;
                }
                if (!DynamicSignMenu.signTypes.get(buttonIndex).signModeltype().equals(Utilities.SignModelTypes.RECTANGLE.getModelTypeName())) continue;
                guiGraphics.blit(res, x, y, 0.0f, 0.0f, 14, 14, 128, 64);
            }
        }
        Lighting.setupFor3DItems();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        String translationKey = ((DynamicSignMenu)this.menu).be.holderList.typesHolderObjectList().get(0).getSignType().translationKey();
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"container.thingamajigslongroads.dynamic_sign.sign_type").append((Component)Component.translatable((String)translationKey)), this.titleLabelX + 9, this.titleLabelY + 98, TColors.getWhite(), true);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.customTextureEdit.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int key, int b, int c) {
        return this.customTextureEdit.keyPressed(key, b, c) || this.customTextureEdit.isFocused() && key != 256 || super.keyPressed(key, b, c);
    }

    private void setup() {
        int spacingButtonWidth;
        int horzLeftButtonPos = this.leftPos + 100;
        int topRowButtonY = this.topPos + 68;
        int spacingButtonHeight = spacingButtonWidth = 2;
        float lowPitch = 0.95f;
        float normalPitch = 1.0f;
        String assetID = "thingamajigslongroads:test";
        this.customTextureEdit = new DynamicEditBox(this.font, this.leftPos + 12, this.topPos + 139, 154, 19, (Component)Component.literal((String)assetID).withStyle(ChatFormatting.DARK_GRAY));
        this.customTextureEdit.setEditable(true);
        try {
            assetID = ((DynamicSignMenu)this.menu).be.holderList.typesHolderObjectList().getFirst().getSignType().assetId().toString();
            this.customTextureEdit.setValue(assetID);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("DynamicSignMenu SELECT_SIGN_TYPE did not return data to DynamicRoadSignScreen properly. ERR: {}", (Object)e.getMessage());
        }
        this.decreaseRotation = new RevertedButton(this, horzLeftButtonPos, topRowButtonY, 64, 16, (Component)Component.translatable((String)"button.thingamajigslongroads.rotation_left"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(((DynamicSignMenu)this.menu).pos, ((DynamicSignMenu)this.menu).be.yAngle - 0.01f, ((DynamicSignMenu)this.menu).be.indexId, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)lowPitch));
        }){};
        int horzRightButtonPos = this.decreaseRotation.getX() + this.decreaseRotation.getWidth() + spacingButtonWidth;
        this.increaseRotation = new RevertedButton(this, horzRightButtonPos, topRowButtonY, 64, 16, (Component)Component.translatable((String)"button.thingamajigslongroads.rotation_right"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(((DynamicSignMenu)this.menu).pos, ((DynamicSignMenu)this.menu).be.yAngle + 0.01f, ((DynamicSignMenu)this.menu).be.indexId, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)normalPitch));
        }){};
        this.roundRotation = new RevertedButton(horzLeftButtonPos, topRowButtonY + 72, 64, 16, (Component)Component.translatable((String)"button.thingamajigslongroads.round_rotation"), handler -> PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(((DynamicSignMenu)this.menu).pos, Math.round(((DynamicSignMenu)this.menu).be.yAngle), ((DynamicSignMenu)this.menu).be.indexId, false), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = this.leftPos + this.listButtonStartX;
        int j = this.topPos + this.listButtonStartY;
        for (int k = 0; k < 4; ++k) {
            for (int l = 0; l < 4; ++l) {
                double d0 = mouseX - (double)(i + l * 14);
                double d1 = mouseY - (double)(j + k * 14);
                int i1 = k + this.startRow;
                int buttonIndex = i1 * 4 + l;
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 14.0) || !(d1 < 14.0) || !((DynamicSignMenu)this.menu).clickedSignTypeSelectorButton((Player)this.minecraft.player, buttonIndex)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((DynamicSignMenu)this.menu).containerId, buttonIndex);
                PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(((DynamicSignMenu)this.menu).pos, ((DynamicSignMenu)this.menu).be.yAngle, buttonIndex, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        i = this.leftPos + 119;
        j = this.topPos + 9;
        if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 56)) {
            this.scrolling = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        DynamicSignMenu cfr_ignored_0 = (DynamicSignMenu)this.menu;
        int i = DynamicSignMenu.signTypes.size() - 4;
        if (this.scrolling && i > 0) {
            int j = this.topPos + 13;
            int k = j + 56;
            this.scrollOffs = ((float)mouseY - (float)j - 7.5f) / ((float)(k - j) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startRow = Math.max((int)((double)(this.scrollOffs * (float)i) + 0.5), 0);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        DynamicSignMenu cfr_ignored_0 = (DynamicSignMenu)this.menu;
        int i = DynamicSignMenu.signTypes.size() - 4;
        if (i > 0) {
            float f = (float)scrollY / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startRow = Math.max((int)(this.scrollOffs * (float)i + 0.5f), 0);
        }
        return true;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return mouseX < (double)guiLeft || mouseY < (double)guiTop || mouseX >= (double)(guiLeft + this.imageWidth) || mouseY >= (double)(guiTop + this.imageHeight);
    }

    protected void containerTick() {
        DynamicSignMenu cfr_ignored_0 = (DynamicSignMenu)this.menu;
        if (this.startRow > DynamicSignMenu.signTypes.size()) {
            this.startRow = 0;
            this.scrollOffs = 0.0f;
        }
    }
}

