/*
 * Decompiled with CFR 0.152.
 */
package net.rk.longroads.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.rk.longroads.registries.SignType;
import net.rk.longroads.registries.TLRRegistries;
import net.rk.longroads.util.SignTypeKeys;
import org.slf4j.Logger;

public record SignTypeHolderObject(List<HolderSignType> typesHolderObjectList) {
    private static final Logger signTypeHolderObjectLogger = LogUtils.getLogger();
    public static final SignTypeHolderObject NOTHING = new SignTypeHolderObject(List.of());
    public static final Codec<SignTypeHolderObject> CODEC = HolderSignType.CODEC.listOf().xmap(SignTypeHolderObject::new, SignTypeHolderObject::typesHolderObjectList);
    public static final StreamCodec<RegistryFriendlyByteBuf, SignTypeHolderObject> STREAM_CODEC = HolderSignType.STREAM_CODEC.apply(ByteBufCodecs.list()).map(SignTypeHolderObject::new, SignTypeHolderObject::typesHolderObjectList);

    @Override
    public String toString() {
        return "SignTypeHolderObject has list of: " + String.valueOf(this.typesHolderObjectList().stream().toList());
    }

    public static SignTypeHolderObject makeDefaultSign(Level level) {
        HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(TLRRegistries.SIGN_TYPE);
        return new Builder().addIfRegistered((HolderGetter<SignType>)registry, SignTypeKeys.PlACEHOLDER).buildSignTypeHolderBuilder();
    }

    public static class Builder {
        private final ImmutableList.Builder<HolderSignType> holderSignTypesList = ImmutableList.builder();

        public Builder add(Holder<SignType> holder) {
            return this.add(new HolderSignType(holder));
        }

        public Builder add(HolderSignType holders) {
            this.holderSignTypesList.add((Object)holders);
            return this;
        }

        public Builder addAll(SignTypeHolderObject holders) {
            this.holderSignTypesList.addAll(holders.typesHolderObjectList);
            return this;
        }

        public Builder addIfRegistered(HolderGetter<SignType> signTypes, ResourceKey<SignType> signTypeKey) {
            Optional optional = signTypes.get(signTypeKey);
            if (optional.isEmpty()) {
                signTypeHolderObjectLogger.warn("Unable to find SignType with ID: '{}'", (Object)signTypeKey.location());
                return this;
            }
            return this.add((Holder<SignType>)((Holder)optional.get()));
        }

        public SignTypeHolderObject buildSignTypeHolderBuilder() {
            return new SignTypeHolderObject((List<HolderSignType>)this.holderSignTypesList.build());
        }
    }

    public record HolderSignType(Holder<SignType> signType) {
        public static final Codec<HolderSignType> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SignType.HOLDER_CODEC.fieldOf("signType").forGetter(HolderSignType::signType)).apply((Applicative)builder, HolderSignType::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HolderSignType> STREAM_CODEC = StreamCodec.composite(SignType.STREAM_CODEC, HolderSignType::signType, HolderSignType::new);

        public MutableComponent getDescription() {
            return Component.literal((String)this.toString()).append((Component)Component.translatable((String)((SignType)this.signType.value()).translationKey()));
        }

        public SignType getSignType() {
            return (SignType)this.signType.value();
        }
    }
}

