/*
 * Decompiled with CFR 0.152.
 */
package com.HeroxWar.HeroxCore.TimeGesture.Date;

import com.HeroxWar.HeroxCore.TimeGesture.Date.DateException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Date {
    private static final Logger logger = Logger.getLogger(Date.class.getName());
    private SimpleDateFormat sdf;
    private long milliseconds;
    private String date;
    private Timestamp timestamp;

    public Date() {
        this.sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
        this.milliseconds = System.currentTimeMillis();
        this.timestamp = new Timestamp(this.milliseconds);
        this.date = this.sdf.format(this.timestamp);
    }

    public Date(char formatter) {
        this(formatter, System.currentTimeMillis());
    }

    public Date(char formatter, long milliseconds) {
        this.sdf = new SimpleDateFormat("yyyy" + formatter + "MM" + formatter + "dd" + formatter + "HH" + formatter + "mm" + formatter + "ss");
        this.setMilliseconds(milliseconds);
    }

    public Date(char formatter, String date) {
        this.sdf = new SimpleDateFormat("yyyy" + formatter + "MM" + formatter + "dd" + formatter + "HH" + formatter + "mm" + formatter + "ss");
        this.setDate(date);
    }

    public Date(char formatter, java.util.Date date) {
        this.sdf = new SimpleDateFormat("yyyy" + formatter + "MM" + formatter + "dd" + formatter + "HH" + formatter + "mm" + formatter + "ss");
        this.setMilliseconds(date.getTime());
    }

    public Date(String pattern) {
        this(pattern, System.currentTimeMillis());
    }

    public Date(String pattern, long milliseconds) {
        this.sdf = new SimpleDateFormat(pattern);
        this.setMilliseconds(milliseconds);
    }

    public Date(String pattern, String date) {
        this.sdf = new SimpleDateFormat(pattern);
        this.setDate(date);
    }

    public Date(String pattern, java.util.Date date) {
        this.sdf = new SimpleDateFormat(pattern);
        this.setMilliseconds(date.getTime());
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
        this.timestamp = new Timestamp(milliseconds);
        this.date = this.sdf.format(this.timestamp);
    }

    public String getDate() {
        return this.date;
    }

    public java.util.Date getUtilDate() {
        try {
            return this.sdf.parse(this.date);
        }
        catch (ParseException e) {
            try {
                throw new DateException("!!!! THE PATTERN OF DATE IS NOT THE SAME CONFIGURED: " + this.getPattern() + " " + this.date);
            }
            catch (DateException ex) {
                logger.log(Level.WARNING, ex.getMessage());
                return null;
            }
        }
    }

    public void setDate(String date) {
        try {
            java.util.Date dateTemp = this.sdf.parse(date);
            this.setMilliseconds(dateTemp.getTime());
        }
        catch (ParseException e) {
            try {
                throw new DateException("!!!! THE PATTERN OF DATE IS NOT THE SAME CONFIGURED: " + this.getPattern() + " " + date);
            }
            catch (DateException ex) {
                logger.log(Level.WARNING, ex.getMessage());
            }
        }
    }

    public void setPattern(String pattern) {
        this.sdf = new SimpleDateFormat(pattern);
        this.date = this.sdf.format(this.timestamp);
    }

    public String getPattern() {
        return this.sdf.toPattern();
    }

    public boolean equals(Object date) {
        if (date instanceof Date) {
            return ((Date)date).getMilliseconds() == this.milliseconds;
        }
        return false;
    }

    public Date cloneDate() {
        return new Date(this.sdf.toPattern(), this.milliseconds);
    }

    public boolean isBiggerThen(Date date) {
        return date.getMilliseconds() > this.milliseconds;
    }

    public Date differenceBetween(Date date) {
        boolean isBigger = this.isBiggerThen(date);
        Date dateToReturn = isBigger ? new Date(this.sdf.toPattern(), date.getMilliseconds() - this.getMilliseconds()) : new Date(this.sdf.toPattern(), this.getMilliseconds() - date.getMilliseconds());
        return dateToReturn;
    }

    public void difference(Date date) {
        Date dateToReturn = this.differenceBetween(date);
        this.setMilliseconds(dateToReturn.getMilliseconds());
        this.setPattern(dateToReturn.getPattern());
    }

    public Date sumBetween(Date date) {
        return new Date(this.sdf.toPattern(), this.getMilliseconds() + date.getMilliseconds());
    }

    public void sum(Date date) {
        Date dateSum = this.sumBetween(date);
        this.setMilliseconds(dateSum.getMilliseconds());
        this.setPattern(dateSum.getPattern());
    }

    public String toString() {
        return "Date{sdf=" + String.valueOf(this.sdf) + ", milliseconds=" + this.milliseconds + ", date='" + this.date + "', timestamp=" + String.valueOf(this.timestamp) + "}";
    }
}

