/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.CustomAnvilGUI.Database;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.HeroxWar.HeroxCore.SoundGesture.SoundType;
import io.eliotesta98.CustomAnvilGUI.Core.Main;
import io.eliotesta98.CustomAnvilGUI.Database.Objects.PaymentConfig;
import io.eliotesta98.CustomAnvilGUI.Interfaces.FloodgateInput;
import io.eliotesta98.CustomAnvilGUI.Interfaces.Interface;
import io.eliotesta98.CustomAnvilGUI.Interfaces.ItemConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigGestion {
    private final HashMap<String, Boolean> hooks = new HashMap();
    private final HashMap<String, String> messages = new HashMap();
    private final HashMap<String, Boolean> debug = new HashMap();
    private final HashMap<String, Interface> interfaces = new HashMap();
    private final SoundType stageSound;
    private final int percentageDamage;
    private final boolean directRename;
    private final boolean onlyBedrock;
    private final PaymentConfig fixHandPayment;
    private final PaymentConfig fixInventoryPayment;

    public ConfigGestion(FileConfiguration file) {
        String prefix = "";
        for (String message : file.getConfigurationSection("Messages").getKeys(false)) {
            if (message.equalsIgnoreCase("Commands")) {
                for (String commands : file.getConfigurationSection("Messages.Commands").getKeys(false)) {
                    this.messages.put(message + "." + commands, file.getString("Messages.Commands." + commands));
                }
                continue;
            }
            if (message.equalsIgnoreCase("Prefix")) {
                prefix = file.getString("Messages." + message);
                this.messages.put(message, prefix);
                continue;
            }
            if (message.equalsIgnoreCase("Lists")) {
                for (String success : file.getConfigurationSection("Messages.Lists").getKeys(false)) {
                    this.messages.put(message + "." + success, file.getString("Messages.Lists." + success).replace("{prefix}", prefix));
                }
                continue;
            }
            if (message.equalsIgnoreCase("Warnings") || message.equalsIgnoreCase("Errors") || message.equalsIgnoreCase("Success") || message.equalsIgnoreCase("Info") || message.equalsIgnoreCase("Results")) {
                for (String success : file.getConfigurationSection("Messages." + message).getKeys(false)) {
                    this.messages.put(message + "." + success, file.getString("Messages." + message + "." + success).replace("{prefix}", prefix));
                }
                continue;
            }
            this.messages.put(message, file.getString("Messages." + message).replace("{prefix}", prefix));
        }
        for (String event : file.getConfigurationSection("Debug").getKeys(false)) {
            this.debug.put(event, file.getBoolean("Debug." + event));
        }
        for (String hook : file.getConfigurationSection("Configuration.Hooks").getKeys(false)) {
            this.hooks.put(hook, file.getBoolean("Configuration.Hooks." + hook));
        }
        this.percentageDamage = file.getInt("Configuration.AnvilDamage.Damage", 12);
        this.directRename = file.getBoolean("Configuration.DirectRename");
        this.onlyBedrock = file.getBoolean("Configuration.OnlyBedrock");
        this.stageSound = new SoundType(file.getString("Configuration.AnvilSound.SoundName"), file.getDouble("Configuration.AnvilSound.Volume"), file.getDouble("Configuration.AnvilSound.Pitch"));
        String messageNotEnoughMaterial = this.messages.get("Errors.NotEnoughMaterial");
        String messageNotEnoughExperience = this.messages.get("Errors.NotEnoughExperience");
        String messageNotEnoughMoney = this.messages.get("Errors.NotEnoughMoney");
        boolean vaultEnable = this.hooks.get("Vault");
        this.fixHandPayment = new PaymentConfig(file.getBoolean("Configuration.FixItems.Hand.Payment.Enabled"), file.getDouble("Configuration.FixItems.Hand.Payment.Price"), file.getString("Configuration.FixItems.Hand.Payment.Type"), file.getString("Configuration.FixItems.Hand.Payment.Calculation"), messageNotEnoughMoney, messageNotEnoughMaterial, messageNotEnoughExperience, vaultEnable, "cagui.fix.hand.bypass");
        this.fixInventoryPayment = new PaymentConfig(file.getBoolean("Configuration.FixItems.Inventory.Payment.Enabled"), file.getDouble("Configuration.FixItems.Inventory.Payment.Price"), file.getString("Configuration.FixItems.Inventory.Payment.Type"), file.getString("Configuration.FixItems.Inventory.Payment.Calculation"), messageNotEnoughMoney, messageNotEnoughMaterial, messageNotEnoughExperience, vaultEnable, "cagui.fix.inventory.bypass");
        for (String nameInterface : file.getConfigurationSection("Interface").getKeys(false)) {
            Object number2;
            String title = file.getString("Interface." + nameInterface + ".Title");
            String rawSound = file.getString("Interface." + nameInterface + ".OpenSound.SoundName", "minecraft:entity.allay.item_thrown");
            double volume = file.getDouble("Interface." + nameInterface + ".OpenSound.SoundName", 100.0);
            double pitch = file.getDouble("Interface." + nameInterface + ".OpenSound.SoundName", 2.0);
            SoundType openSound = new SoundType(rawSound, volume, pitch);
            ArrayList<String> slots = new ArrayList<String>();
            ArrayList contaSlots = new ArrayList();
            ArrayList<FloodgateInput> inputs = new ArrayList<FloodgateInput>();
            if (file.isConfigurationSection("Interface." + nameInterface + ".Floodgate")) {
                for (Object number2 : file.getConfigurationSection("Interface." + nameInterface + ".Floodgate").getKeys(false)) {
                    String base = "Interface." + nameInterface + ".Floodgate." + (String)number2;
                    FloodgateInput floodgateInput = new FloodgateInput(file.getString(base + ".Type"), file.getString(base + ".Label"), file.getString(base + ".Placeholder", ""), file.getString(base + ".DefaultText", ""));
                    inputs.add(floodgateInput);
                }
            }
            HashMap<String, ItemConfig> itemsConfig = new HashMap<String, ItemConfig>();
            number2 = file.getConfigurationSection("Interface." + nameInterface + ".Items").getKeys(false).iterator();
            while (number2.hasNext()) {
                String nameItem = (String)number2.next();
                String letter = file.getString("Interface." + nameInterface + ".Items." + nameItem + ".Letter");
                String type = file.getString("Interface." + nameInterface + ".Items." + nameItem + ".Type", "");
                if (!type.equalsIgnoreCase("")) {
                    if (type.contains(";")) {
                        String[] x = type.split(";");
                        if (Material.getMaterial((String)x[0]) == null) {
                            MessageGesture.sendMessage((CommandSender)Main.instance.getServer().getConsoleSender(), "&c&lERROR WITH MATERIAL " + x[0] + " IN CONFIG.YML AT LINE: Interfaces." + nameInterface + ".Items." + nameItem + ".Type");
                            type = "DIRT";
                        }
                    } else if (Material.getMaterial((String)type) == null) {
                        MessageGesture.sendMessage((CommandSender)Main.instance.getServer().getConsoleSender(), "&c&lERROR WITH MATERIAL " + type + " IN CONFIG.YML AT LINE: Interfaces." + nameInterface + ".Items." + nameItem + ".Type");
                        type = "DIRT";
                    }
                }
                String name = file.getString("Interface." + nameInterface + ".Items." + nameItem + ".Name");
                String texture = file.getString("Interface." + nameInterface + ".Items." + nameItem + ".Texture");
                String soundClick = file.getString("Interface." + nameInterface + ".Items." + nameItem + ".SoundClick");
                ArrayList<String> lore = new ArrayList<String>(file.getStringList("Interface." + nameInterface + ".Items." + nameItem + ".Lore"));
                ItemConfig item = new ItemConfig(nameItem, name, type, texture, lore, soundClick);
                itemsConfig.put(letter, item);
            }
            file.getStringList("Interface." + nameInterface + ".Slots").forEach(value -> {
                for (int i = 0; i < value.length(); ++i) {
                    for (Map.Entry itemConfig : itemsConfig.entrySet()) {
                        if (!((String)itemConfig.getKey()).equalsIgnoreCase(value.charAt(i) + "") || !((ItemConfig)itemConfig.getValue()).getNameItemConfig().equalsIgnoreCase("Item")) continue;
                        contaSlots.add("" + value.charAt(i));
                    }
                    slots.add("" + value.charAt(i));
                }
            });
            Interface customInterface = new Interface(title, openSound, slots, itemsConfig, inputs, this.debug.get("ClickGui"), contaSlots.size(), nameInterface, "", "");
            customInterface.initialize(this.messages.get("Success.Rename"), this.directRename, this.messages.get("Errors.InsufficientExperience"));
            this.interfaces.put(nameInterface, customInterface);
        }
    }

    public HashMap<String, Boolean> getHooks() {
        return this.hooks;
    }

    public HashMap<String, String> getMessages() {
        return this.messages;
    }

    public HashMap<String, Boolean> getDebug() {
        return this.debug;
    }

    public HashMap<String, Interface> getInterfaces() {
        return this.interfaces;
    }

    public int getPercentageDamage() {
        return this.percentageDamage;
    }

    public boolean isDirectRename() {
        return this.directRename;
    }

    public SoundType getStageSound() {
        return this.stageSound;
    }

    public boolean isOnlyBedrock() {
        return this.onlyBedrock;
    }

    public PaymentConfig getFixHandPayment() {
        return this.fixHandPayment;
    }

    public PaymentConfig getFixInventoryPayment() {
        return this.fixInventoryPayment;
    }

    public String toString() {
        return "ConfigGestion{hooks=" + this.hooks + ", messages=" + this.messages + ", debug=" + this.debug + '}';
    }
}

