/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.CustomAnvilGUI.Database.Objects;

import com.HeroxWar.HeroxCore.MessageGesture;
import io.eliotesta98.CustomAnvilGUI.Module.Vault.VaultUtils;
import javax.script.ScriptException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PaymentConfig {
    private boolean enabled;
    private double price;
    private String type;
    private String calculation = "";
    private String notEnoughMoney = "";
    private String notEnoughMaterial = "";
    private String notEnoughExperience = "";
    private String bypassPermission = "";
    private boolean vaultEnabled = false;

    public PaymentConfig(boolean enabled, double price, String type, String calculation, String messageNotEnoughMoney, String messageNotEnoughMaterial, String messageNotEnoughExperience, boolean vaultEnabled, String bypassPermission) {
        this.enabled = enabled;
        this.price = price;
        this.type = type;
        this.calculation = calculation;
        this.notEnoughExperience = messageNotEnoughExperience;
        this.notEnoughMaterial = messageNotEnoughMaterial;
        this.notEnoughMoney = messageNotEnoughMoney;
        this.vaultEnabled = vaultEnabled;
        this.bypassPermission = bypassPermission;
    }

    public PaymentConfig(boolean enabled, double price, String type, String messageNotEnoughMoney, String messageNotEnoughMaterial, String messageNotEnoughExperience, boolean vaultEnabled, String bypassPermission) {
        this.enabled = enabled;
        this.price = price;
        this.type = type;
        this.notEnoughExperience = messageNotEnoughExperience;
        this.notEnoughMaterial = messageNotEnoughMaterial;
        this.notEnoughMoney = messageNotEnoughMoney;
        this.vaultEnabled = vaultEnabled;
        this.bypassPermission = bypassPermission;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCalculation() {
        return this.calculation;
    }

    public void setCalculation(String calculation) {
        this.calculation = calculation;
    }

    public double calculatePrice(Player player, boolean handOrInventory) {
        if (handOrInventory) {
            ItemStack itemInHand = player.getItemInHand();
            if (itemInHand == null) {
                return 0.0;
            }
            if (itemInHand.getType() == Material.AIR) {
                return 0.0;
            }
            return this.placeholderPrice(itemInHand.getDurability(), 1.0);
        }
        double price = 0.0;
        for (ItemStack itemStack : player.getInventory().getStorageContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            price += this.placeholderPrice(itemStack.getDurability(), 1.0);
        }
        return price;
    }

    public double placeholderPrice(double ... informations) {
        double price = 0.0;
        try {
            price = this.calculateFunction(this.calculation.replace("{durability}", "" + informations[0]).replace("{numberOfItems}", "" + informations[1]).replace("{price}", "" + this.price));
        }
        catch (ScriptException e) {
            return price;
        }
        return price;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean pay(Player p, double price) {
        if (p.hasPermission(this.bypassPermission)) {
            return true;
        }
        if (price <= 0.0) {
            price = this.price;
        }
        if (!this.enabled) return true;
        if (this.type.equalsIgnoreCase("Money")) {
            if (this.vaultEnabled) {
                if (VaultUtils.pay(p, price)) return true;
                MessageGesture.sendMessage((CommandSender)p, this.notEnoughMoney);
                return false;
            }
            MessageGesture.sendMessage((CommandSender)Bukkit.getServer().getConsoleSender(), "&c&lERROR WITH CONFIGURATION AT Configuration.BreakGesture.Payment.Type, IF YOU WANT THIS PAYMENT TYPE PLEASE ENABLE VAULT COMPATIBILITY!");
            return true;
        }
        if (this.type.equalsIgnoreCase("Experience")) {
            int levelPayment = (int)price;
            int finalLevel = p.getLevel() - levelPayment;
            if (finalLevel >= 0) {
                p.setLevel(finalLevel);
                return true;
            }
            MessageGesture.sendMessage((CommandSender)p, this.notEnoughExperience);
            return false;
        }
        String[] material = this.type.split(":");
        Material realMaterial = Material.getMaterial((String)material[1]);
        ItemStack itemStack = new ItemStack(realMaterial, (int)price);
        if (material.length == 3) {
            itemStack = new ItemStack(realMaterial, (int)price, Short.parseShort(material[2]));
        }
        if (!p.getInventory().contains(itemStack.getType(), (int)price)) {
            MessageGesture.sendMessage((CommandSender)p, this.notEnoughMaterial);
            return false;
        }
        int itemSlot = p.getInventory().first(itemStack.getType());
        itemStack = p.getInventory().getItem(itemSlot);
        p.getInventory().getItem(itemSlot).setAmount((int)((double)itemStack.getAmount() - price));
        return true;
    }

    public boolean customPay(Player p, double ... informations) {
        try {
            double price = this.calculateFunction(this.calculation.replace("{durability}", "" + informations[0]).replace("{numberOfItems}", "" + informations[1]).replace("{price}", "" + this.price));
            boolean payed = this.pay(p, price);
            if (!payed) {
                return false;
            }
        }
        catch (ScriptException e) {
            MessageGesture.sendMessage((CommandSender)p, "&cAn Internal Error Occurred with function for calculate the price of tp");
            return false;
        }
        return true;
    }

    private double calculateFunction(String expression) throws ScriptException {
        double calculate;
        block5: {
            block7: {
                block6: {
                    block4: {
                        calculate = -1.0;
                        if (!expression.contains("*")) break block4;
                        String[] operation = expression.split("\\*");
                        calculate = Double.parseDouble(operation[0]);
                        for (int i = 1; i < operation.length; ++i) {
                            calculate *= Double.parseDouble(operation[i]);
                        }
                        break block5;
                    }
                    if (!expression.contains("/")) break block6;
                    String[] operation = expression.split("/");
                    calculate = Double.parseDouble(operation[0]);
                    for (int i = 1; i < operation.length; ++i) {
                        calculate /= Double.parseDouble(operation[i]);
                    }
                    break block5;
                }
                if (!expression.contains("+")) break block7;
                String[] operation = expression.split("\\+");
                calculate = Double.parseDouble(operation[0]);
                for (int i = 1; i < operation.length; ++i) {
                    calculate += Double.parseDouble(operation[i]);
                }
                break block5;
            }
            if (!expression.contains("-")) break block5;
            String[] operation = expression.split("-");
            calculate = Double.parseDouble(operation[0]);
            for (int i = 1; i < operation.length; ++i) {
                calculate -= Double.parseDouble(operation[i]);
            }
        }
        return calculate;
    }
}

