/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.CustomAnvilGUI.Events;

import com.HeroxWar.HeroxCore.MessageGesture;
import io.eliotesta98.CustomAnvilGUI.Core.Main;
import io.eliotesta98.CustomAnvilGUI.Interfaces.GuiEvent;
import io.eliotesta98.CustomAnvilGUI.Utils.ExpUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerWriteEvent
implements Listener {
    private final Map<String, ItemStack> renamingPlayers = new HashMap<String, ItemStack>();
    private final Map<String, ItemStack> itemInHands = new HashMap<String, ItemStack>();
    private final String successfullyRename = Main.instance.getConfigGestion().getMessages().get("Success.Rename");
    private final String insufficientExp = Main.instance.getConfigGestion().getMessages().get("Errors.InsufficientExperience");
    private final boolean directRename = Main.instance.getConfigGestion().isDirectRename();
    private Location anvilLocation;
    private Inventory inv;

    public void setAnvilLocation(Location location) {
        this.anvilLocation = location;
    }

    public void setInventory(Inventory inv) {
        this.inv = inv;
    }

    public Location getAnvilLocation() {
        return this.anvilLocation;
    }

    public Inventory getInv() {
        return this.inv;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerWrite(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (this.renamingPlayers.containsKey(player.getName()) && this.renamingPlayers.get(player.getName()) == null) {
            this.renamingPlayers.replace(player.getName(), this.createItemStack(message));
            if (this.directRename) {
                int experienceRaw = ExpUtils.getExp(player);
                double levels = ExpUtils.getLevelFromExp(experienceRaw);
                if (levels >= 1.0) {
                    ItemStack itemInHand = this.itemInHands.get(player.getName());
                    player.getInventory().remove(itemInHand);
                    ItemMeta itemMeta = itemInHand.getItemMeta();
                    itemMeta.setDisplayName(message);
                    itemInHand.setItemMeta(itemMeta);
                    player.getInventory().addItem(new ItemStack[]{itemInHand});
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> GuiEvent.damageAnvil(player, this.anvilLocation, this.inv));
                    ExpUtils.changeExpLevels(player, -1);
                } else {
                    MessageGesture.sendMessage((CommandSender)player, this.insufficientExp);
                }
                this.renamingPlayers.remove(player.getName());
            } else {
                MessageGesture.sendMessage((CommandSender)player, this.successfullyRename);
            }
            event.setCancelled(true);
        }
    }

    public boolean isPlayerRename(String playerName) {
        return this.renamingPlayers.containsKey(playerName);
    }

    public ItemStack getItemWithPlayerName(String playerName) {
        return this.renamingPlayers.get(playerName);
    }

    public ItemStack getItemInHand(String playerName) {
        return this.itemInHands.get(playerName);
    }

    public void addPlayer(String playerName, ItemStack itemInHand) {
        if (this.renamingPlayers.containsKey(playerName)) {
            this.renamingPlayers.replace(playerName, null);
            this.itemInHands.replace(playerName, itemInHand);
        } else {
            this.renamingPlayers.put(playerName, null);
            this.itemInHands.put(playerName, itemInHand);
        }
    }

    public void addPlayer(String playerName, ItemStack itemInHand, ItemStack itemStack) {
        if (this.renamingPlayers.containsKey(playerName)) {
            this.renamingPlayers.replace(playerName, itemStack);
            this.itemInHands.replace(playerName, itemInHand);
        } else {
            this.renamingPlayers.put(playerName, itemStack);
            this.itemInHands.put(playerName, itemInHand);
        }
    }

    public void removePlayer(String playerName) {
        this.renamingPlayers.remove(playerName);
        this.itemInHands.remove(playerName);
    }

    public ItemStack createItemStack(String message) {
        ItemStack paper = new ItemStack(Material.PAPER);
        ItemMeta itemMeta = paper.getItemMeta();
        itemMeta.setDisplayName(message);
        paper.setItemMeta(itemMeta);
        return paper;
    }

    public void disableEvent() {
        if (this.renamingPlayers.isEmpty()) {
            AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

