/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.CustomAnvilGUI.Interfaces;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.HeroxWar.HeroxCore.SoundGesture.SoundType;
import com.heroxplugins.external.CustomAnvilGUI.de.tr7zw.NBTItem;
import io.eliotesta98.CustomAnvilGUI.Core.Main;
import io.eliotesta98.CustomAnvilGUI.Database.Objects.PaymentConfig;
import io.eliotesta98.CustomAnvilGUI.Events.PlayerWriteEvent;
import io.eliotesta98.CustomAnvilGUI.Interfaces.CustomAnvilGUIHolder;
import io.eliotesta98.CustomAnvilGUI.Interfaces.Interface;
import io.eliotesta98.CustomAnvilGUI.Utils.DebugUtils;
import io.eliotesta98.CustomAnvilGUI.Utils.ExpUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GuiEvent
implements Listener {
    private final PlayerWriteEvent playerWriteEvent = new PlayerWriteEvent();
    private final boolean debugGui = Main.instance.getConfigGestion().getDebug().get("ClickGui");
    private final String insufficientExp = Main.instance.getConfigGestion().getMessages().get("Errors.InsufficientExperience");
    private final String insufficientPermission = Main.instance.getConfigGestion().getMessages().get("Errors.InsufficientPermission");
    private final String noItemInHand = Main.instance.getConfigGestion().getMessages().get("Errors.NoItemInHand");
    private final PaymentConfig fixHandPayment = Main.instance.getConfigGestion().getFixHandPayment();
    private final PaymentConfig fixInventoryPayment = Main.instance.getConfigGestion().getFixInventoryPayment();
    private final String renameInfo = Main.instance.getConfigGestion().getMessages().get("Info.Rename");
    private final String guiInsufficientExp = Main.instance.getConfigGestion().getMessages().get("Results.NoItem");
    private final List<String> whitelistedPlayers = new ArrayList<String>();
    private final DebugUtils debugUtils = new DebugUtils();
    private static final int percentageDamage = Main.instance.getConfigGestion().getPercentageDamage();
    private static final SoundType soundType = Main.instance.getConfigGestion().getStageSound();

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAnvilInventoryOpen(InventoryOpenEvent event) {
        if (event.getInventory().getType().toString().equalsIgnoreCase("ANVIL") && !this.whitelistedPlayers.contains(event.getPlayer().getName())) {
            if (this.debugGui) {
                this.debugUtils.addLine("Open Inventory");
                this.debugUtils.debug("InventoryOpenEvent");
            }
            boolean cancelled = Main.instance.getConfigGestion().getInterfaces().get("Anvil").openInterface((Player)event.getPlayer(), event.getView());
            event.setCancelled(cancelled);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        DebugUtils debug = new DebugUtils();
        long time = System.currentTimeMillis();
        if (event.getInventory().getHolder() instanceof CustomAnvilGUIHolder) {
            if (this.debugGui) {
                debug.addLine("Custom Anvil Closing");
            }
            Main.instance.getConfigGestion().getInterfaces().get("Anvil").removeInventory(event.getPlayer().getName(), event.getInventory(), event.getPlayer().getLocation(), false);
        }
        if (event.getInventory().getType().toString().equalsIgnoreCase("ANVIL")) {
            if (this.debugGui) {
                debug.addLine("Removing from whitelist");
            }
            this.whitelistedPlayers.remove(event.getPlayer().getName());
        }
        if (this.debugGui) {
            debug.addLine("Gui execution time= " + (System.currentTimeMillis() - time));
            debug.debug("InventoryCloseEvent");
        }
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        DebugUtils debug = new DebugUtils();
        long time = System.currentTimeMillis();
        if (event.getPlayer().getOpenInventory().getTopInventory().getHolder() instanceof CustomAnvilGUIHolder) {
            Main.instance.getConfigGestion().getInterfaces().get("Anvil").removeInventory(event.getPlayer().getName(), event.getPlayer().getOpenInventory().getTopInventory(), event.getPlayer().getLocation(), true);
        }
        if (this.debugGui) {
            debug.addLine("Gui execution time= " + (System.currentTimeMillis() - time));
            debug.debug("PlayerQuitEvent");
        }
    }

    @EventHandler
    public void onPlayerKickEvent(PlayerKickEvent event) {
        DebugUtils debug = new DebugUtils();
        long time = System.currentTimeMillis();
        if (event.getPlayer().getOpenInventory().getTopInventory().getHolder() instanceof CustomAnvilGUIHolder) {
            Main.instance.getConfigGestion().getInterfaces().get("Anvil").removeInventory(event.getPlayer().getName(), event.getPlayer().getOpenInventory().getTopInventory(), event.getPlayer().getLocation(), true);
        }
        if (this.debugGui) {
            debug.addLine("Gui execution time= " + (System.currentTimeMillis() - time));
            debug.debug("PlayerKickEvent");
        }
    }

    public static Inventory getTopInventory(Object view) {
        try {
            Method getTopInventory = view.getClass().getMethod("getTopInventory", new Class[0]);
            getTopInventory.setAccessible(true);
            return (Inventory)getTopInventory.invoke(view, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inv = event.getClickedInventory();
        if (inv == null) {
            if (this.debugGui) {
                this.debugUtils.addLine("Inventory is null");
                this.debugUtils.debug("Click Gui");
            }
            return;
        }
        if (inv.getHolder() instanceof CustomAnvilGUIHolder) {
            Player p = (Player)event.getWhoClicked();
            InventoryView inventoryView = Main.instance.getConfigGestion().getInterfaces().get("Anvil").getInventoryFromName(p.getName());
            if (inventoryView == null) {
                event.setCancelled(true);
                if (this.debugGui) {
                    this.debugUtils.addLine("Inventory View is null");
                    this.debugUtils.debug("Click Gui");
                }
                return;
            }
            Inventory topInventory = GuiEvent.getTopInventory(inventoryView);
            Location anvilLocation = topInventory.getLocation();
            Material anvilType = anvilLocation.getBlock().getType();
            ClickType clickType = event.getClick();
            if (anvilType != Material.ANVIL && anvilType != Material.DAMAGED_ANVIL && anvilType != Material.CHIPPED_ANVIL) {
                p.closeInventory();
                if (this.debugGui) {
                    this.debugUtils.addLine("Anvil block not exist");
                    this.debugUtils.debug("Click Gui");
                }
                return;
            }
            String typeInterface = "Anvil";
            Interface customInterface = Main.instance.getConfigGestion().getInterfaces().get(typeInterface);
            List<String> slots = customInterface.getSlots();
            String nameItemConfig = customInterface.getItemsConfig().get(slots.get(event.getSlot())).getNameItemConfig();
            if (event.getCurrentItem() != null && customInterface.getItemsConfig().get(slots.get(event.getSlot())).getType().equalsIgnoreCase(event.getCurrentItem().getType().toString())) {
                event.setCancelled(true);
                if (nameItemConfig.equalsIgnoreCase("Back")) {
                    p.closeInventory();
                    topInventory.setItem(0, null);
                    topInventory.setItem(1, null);
                    this.whitelistedPlayers.add(p.getName());
                    customInterface.removeInventory(p.getName(), event.getClickedInventory(), p.getLocation(), true);
                    try {
                        p.openInventory(inventoryView);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (nameItemConfig.equalsIgnoreCase("Submit")) {
                    ItemStack secondItem;
                    topInventory.clear();
                    ItemStack firstItem = inv.getItem(customInterface.getImportantSlots().get("FirstItem").intValue());
                    if (firstItem == null) {
                        firstItem = new ItemStack(Material.AIR);
                    }
                    if ((secondItem = inv.getItem(customInterface.getImportantSlots().get("SecondItem").intValue())) == null) {
                        secondItem = new ItemStack(Material.AIR);
                    } else if (secondItem.getType() == Material.PAPER) {
                        ItemStack renamedItem = new ItemStack(firstItem);
                        ItemMeta meta = renamedItem.getItemMeta();
                        meta.setDisplayName(secondItem.getItemMeta().getDisplayName());
                        renamedItem.setItemMeta(meta);
                        NBTItem nbtItem = new NBTItem(renamedItem);
                        nbtItem.setInteger("ap.repairCost", 1);
                        int experienceRaw = ExpUtils.getExp(p);
                        double levels = ExpUtils.getLevelFromExp(experienceRaw);
                        customInterface.setCostOfEnchant(inv, 1);
                        if (levels >= 1.0) {
                            inv.setItem(customInterface.getImportantSlots().get("NoResult").intValue(), nbtItem.getItem());
                        } else {
                            customInterface.setBarrier(inv, this.guiInsufficientExp);
                        }
                        return;
                    }
                    topInventory.setItem(0, firstItem);
                    topInventory.setItem(1, secondItem);
                } else if (nameItemConfig.equalsIgnoreCase("Rename")) {
                    ItemStack itemToRename = inv.getItem(customInterface.getImportantSlots().get("FirstItem").intValue());
                    if (itemToRename != null && inv.getItem(customInterface.getImportantSlots().get("SecondItem").intValue()) == null) {
                        if (Main.floodgateUtils.isBedrockPlayer(p.getUniqueId())) {
                            if (this.playerWriteEvent.isPlayerRename(p.getName())) {
                                inv.setItem(customInterface.getImportantSlots().get("SecondItem").intValue(), this.playerWriteEvent.getItemWithPlayerName(p.getName()));
                                this.playerWriteEvent.removePlayer(p.getName());
                                GuiEvent.damageAnvil(p, anvilLocation, inv);
                            } else {
                                p.closeInventory();
                                this.playerWriteEvent.setInventory(inv);
                                this.playerWriteEvent.setAnvilLocation(anvilLocation);
                                this.playerWriteEvent.addPlayer(p.getName(), inv.getItem(customInterface.getImportantSlots().get("FirstItem").intValue()));
                                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> Main.instance.getConfigGestion().getInterfaces().get("Rename").openInterface(p, this.playerWriteEvent), 5L);
                            }
                        } else {
                            Bukkit.getServer().getPluginManager().registerEvents((Listener)this.playerWriteEvent, (Plugin)Main.instance);
                            this.playerWriteEvent.setInventory(inv);
                            this.playerWriteEvent.setAnvilLocation(anvilLocation);
                            if (this.playerWriteEvent.isPlayerRename(p.getName())) {
                                inv.setItem(Main.instance.getConfigGestion().getInterfaces().get("Anvil").getImportantSlots().get("SecondItem").intValue(), this.playerWriteEvent.getItemWithPlayerName(p.getName()));
                                this.playerWriteEvent.removePlayer(p.getName());
                                this.playerWriteEvent.disableEvent();
                                GuiEvent.damageAnvil(p, anvilLocation, inv);
                            } else {
                                this.playerWriteEvent.addPlayer(p.getName(), inv.getItem(customInterface.getImportantSlots().get("FirstItem").intValue()));
                                p.closeInventory();
                                MessageGesture.sendMessage((CommandSender)p, this.renameInfo);
                            }
                        }
                    }
                } else if (nameItemConfig.equalsIgnoreCase("Fix")) {
                    if (clickType == ClickType.LEFT) {
                        if (!p.hasPermission("cagui.fix.hand")) {
                            p.closeInventory();
                            MessageGesture.sendMessage((CommandSender)p, this.insufficientPermission);
                            return;
                        }
                        ItemStack itemStack = p.getInventory().getItemInHand();
                        if (itemStack.getType() == Material.AIR) {
                            p.closeInventory();
                            MessageGesture.sendMessage((CommandSender)p, this.noItemInHand);
                        }
                        if (!(itemStack.getItemMeta() instanceof Damageable)) {
                            return;
                        }
                        Damageable itemMeta = (Damageable)itemStack.getItemMeta();
                        int damage = itemMeta.getDamage();
                        if (damage == 0) {
                            return;
                        }
                        boolean payed = this.fixHandPayment.customPay(p, itemMeta.getDamage(), 1.0);
                        if (!payed) {
                            return;
                        }
                        itemMeta.setDamage(0);
                        itemStack.setItemMeta((ItemMeta)itemMeta);
                        GuiEvent.damageAnvil(p, anvilLocation, inv);
                    } else {
                        if (!p.hasPermission("cagui.fix.inventory")) {
                            p.closeInventory();
                            MessageGesture.sendMessage((CommandSender)p, this.insufficientPermission);
                            return;
                        }
                        for (ItemStack itemStack : p.getInventory().getStorageContents()) {
                            Damageable itemMeta;
                            int damage;
                            if (itemStack == null || !(itemStack.getItemMeta() instanceof Damageable) || itemStack.getType() == Material.AIR || (damage = (itemMeta = (Damageable)itemStack.getItemMeta()).getDamage()) == 0) continue;
                            boolean payed = this.fixInventoryPayment.customPay(p, damage, 1.0);
                            if (!payed) break;
                            itemMeta.setDamage(0);
                            itemStack.setItemMeta((ItemMeta)itemMeta);
                            GuiEvent.damageAnvil(p, anvilLocation, inv);
                        }
                    }
                }
                if (this.debugGui) {
                    this.debugUtils.addLine("The item is not null");
                    this.debugUtils.addLine("The item is equals configuration in config.yml");
                    this.debugUtils.debug("Click Gui");
                }
            } else if (event.getCurrentItem() != null) {
                if (this.debugGui) {
                    this.debugUtils.addLine("The item is not null");
                    this.debugUtils.addLine("Activate Section:" + nameItemConfig);
                    this.debugUtils.debug("Click Gui");
                }
                ItemStack firstItem = inv.getItem(customInterface.getImportantSlots().get("SecondItem").intValue());
                if (nameItemConfig.equalsIgnoreCase("Cost")) {
                    event.setCancelled(true);
                } else if (nameItemConfig.equalsIgnoreCase("Fix")) {
                    event.setCancelled(true);
                } else if (nameItemConfig.equalsIgnoreCase("Back")) {
                    event.setCancelled(true);
                } else if (nameItemConfig.equalsIgnoreCase("FirstItem") && firstItem != null && firstItem.getType() == Material.PAPER) {
                    customInterface.setBarrier(inv, " ");
                    customInterface.setBorder(inv, customInterface.getImportantSlots().get("Cost"));
                } else if (nameItemConfig.equalsIgnoreCase("FirstItem")) {
                    customInterface.deleteResult(inv);
                    topInventory.setItem(0, null);
                } else if (nameItemConfig.equalsIgnoreCase("SecondItem") && firstItem != null && firstItem.getType() == Material.PAPER) {
                    event.setCancelled(true);
                    inv.setItem(event.getSlot(), null);
                } else if (nameItemConfig.equalsIgnoreCase("SecondItem")) {
                    customInterface.deleteResult(inv);
                    topInventory.setItem(1, null);
                } else if (nameItemConfig.equalsIgnoreCase("NoResult")) {
                    event.setCancelled(true);
                    int repairCost = 0;
                    if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR) {
                        NBTItem nbtItem = new NBTItem(event.getCurrentItem());
                        repairCost = nbtItem.getInteger("ap.repairCost");
                    }
                    int slotResult = customInterface.getImportantSlots().get("NoResult");
                    ItemStack result = inv.getItem(slotResult);
                    int experienceRaw = ExpUtils.getExp(p);
                    double levels = ExpUtils.getLevelFromExp(experienceRaw);
                    if (levels >= (double)repairCost) {
                        if (result != null) {
                            ExpUtils.changeExpLevels(p, -repairCost);
                            if (p.getInventory().firstEmpty() != -1) {
                                p.getInventory().addItem(new ItemStack[]{result});
                            } else {
                                p.getWorld().dropItem(p.getLocation(), result);
                            }
                            customInterface.setBarrier(inv, " ");
                            customInterface.setBorder(inv, customInterface.getImportantSlots().get("Cost"));
                            customInterface.deleteItemsWhenResult(inv);
                            GuiEvent.damageAnvil(p, anvilLocation, inv);
                        }
                    } else {
                        MessageGesture.sendMessage((CommandSender)p, this.insufficientExp);
                    }
                }
            }
        }
    }

    public static Object getInventoryInfo(InventoryEvent event, String method) {
        try {
            InventoryView view = event.getView();
            Method getPlayer = view.getClass().getMethod(method, new Class[0]);
            getPlayer.setAccessible(true);
            return getPlayer.invoke((Object)view, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onInventoryPrepareAnvilEvent(PrepareAnvilEvent event) {
        Player player = (Player)GuiEvent.getInventoryInfo((InventoryEvent)event, "getPlayer");
        Inventory topInventory = GuiEvent.getTopInventory(player.getOpenInventory());
        if (topInventory.getHolder() instanceof CustomAnvilGUIHolder) {
            int repairCost;
            Interface interface_ = Main.instance.getConfigGestion().getInterfaces().get("Anvil");
            try {
                repairCost = (Integer)GuiEvent.getInventoryInfo((InventoryEvent)event, "getRepairCost");
            }
            catch (RuntimeException exception) {
                repairCost = event.getInventory().getRepairCost();
            }
            String renameText = "";
            try {
                renameText = (String)GuiEvent.getInventoryInfo((InventoryEvent)event, "getRenameText");
            }
            catch (RuntimeException exception) {
                renameText = event.getInventory().getRenameText();
            }
            if (this.debugGui) {
                this.debugUtils.addLine("Custom Anvil Gui");
                this.debugUtils.addLine("Repair Cost: " + repairCost);
                this.debugUtils.addLine("Item Result: " + event.getResult());
                this.debugUtils.addLine("Rename: " + renameText);
                this.debugUtils.debug("PrepareAnvilEvent");
            }
            if (repairCost > 0) {
                if (event.getResult() != null && event.getResult().getType() != Material.AIR) {
                    interface_.setCostOfEnchant(topInventory, repairCost);
                    NBTItem nbtItem = new NBTItem(event.getResult());
                    nbtItem.setInteger("ap.repairCost", repairCost);
                    int experienceRaw = ExpUtils.getExp(player);
                    double levels = ExpUtils.getLevelFromExp(experienceRaw);
                    if (levels >= (double)repairCost) {
                        topInventory.setItem(interface_.getImportantSlots().get("NoResult").intValue(), nbtItem.getItem());
                    } else {
                        interface_.setBarrier(topInventory, this.guiInsufficientExp);
                    }
                }
            } else {
                interface_.deleteResult(topInventory);
            }
        }
    }

    public static void damageAnvil(Player player, Location anvilLocation, Inventory inventory) {
        Random random = new Random();
        int extractedNumber = random.nextInt(100);
        if (extractedNumber <= percentageDamage) {
            Material anvilType = anvilLocation.getBlock().getType();
            if (anvilType == Material.ANVIL) {
                Directional blockData = (Directional)anvilLocation.getBlock().getBlockData();
                BlockFace blockFace = blockData.getFacing();
                anvilLocation.getBlock().setType(Material.CHIPPED_ANVIL);
                blockData = (Directional)anvilLocation.getBlock().getBlockData();
                blockData.setFacing(blockFace);
                anvilLocation.getBlock().setBlockData((BlockData)blockData);
                soundType.playSound(anvilLocation);
            } else if (anvilType == Material.CHIPPED_ANVIL) {
                Directional blockData = (Directional)anvilLocation.getBlock().getBlockData();
                BlockFace blockFace = blockData.getFacing();
                anvilLocation.getBlock().setType(Material.DAMAGED_ANVIL);
                blockData = (Directional)anvilLocation.getBlock().getBlockData();
                blockData.setFacing(blockFace);
                anvilLocation.getBlock().setBlockData((BlockData)blockData);
                soundType.playSound(anvilLocation);
            } else if (anvilType == Material.DAMAGED_ANVIL) {
                anvilLocation.getBlock().setType(Material.AIR);
                player.closeInventory();
                Main.instance.getConfigGestion().getInterfaces().get("Anvil").removeInventory(player.getName(), inventory, player.getLocation(), true);
                soundType.playSound(anvilLocation);
            }
        } else {
            soundType.playSound(anvilLocation);
        }
    }
}

