/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.CustomAnvilGUI.Interfaces;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.HeroxWar.HeroxCore.SoundGesture.SoundType;
import io.eliotesta98.CustomAnvilGUI.Core.Main;
import io.eliotesta98.CustomAnvilGUI.Events.PlayerWriteEvent;
import io.eliotesta98.CustomAnvilGUI.Interfaces.CustomAnvilGUIHolder;
import io.eliotesta98.CustomAnvilGUI.Interfaces.FloodgateInput;
import io.eliotesta98.CustomAnvilGUI.Interfaces.GuiEvent;
import io.eliotesta98.CustomAnvilGUI.Interfaces.ItemConfig;
import io.eliotesta98.CustomAnvilGUI.Utils.ExpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.CustomForm;

public class Interface {
    private String title;
    private String nameInterface;
    private String nameInterfaceToOpen;
    private String nameInterfaceToReturn;
    private SoundType soundOpen;
    private List<String> slots = new ArrayList<String>();
    private Map<String, ItemConfig> itemsConfig = new HashMap<String, ItemConfig>();
    private boolean debug;
    private int sizeModifiableSlot;
    private final Map<String, InventoryView> anvilInventories = new HashMap<String, InventoryView>();
    private final Map<String, Integer> importantSlots = new HashMap<String, Integer>();
    private final Map<String, String> importantSlotsLetter = new HashMap<String, String>();
    private final List<FloodgateInput> floodgateInputs;
    private String successRename;
    private String insufficientExp;
    private boolean directRename;

    public Interface(String title, SoundType soundOpen, ArrayList<String> slots, HashMap<String, ItemConfig> itemsConfig, List<FloodgateInput> floodgateInputs, boolean debug, int sizeModifiableSlot, String nameInterface, String nameInterfaceToOpen, String nameInterfaceToReturn) {
        this.title = MessageGesture.transformColor(title);
        this.soundOpen = soundOpen;
        this.itemsConfig.putAll(itemsConfig);
        this.debug = debug;
        this.sizeModifiableSlot = sizeModifiableSlot;
        this.slots.addAll(slots);
        this.nameInterface = nameInterface;
        this.nameInterfaceToOpen = nameInterfaceToOpen;
        this.nameInterfaceToReturn = nameInterfaceToReturn;
        this.floodgateInputs = floodgateInputs;
    }

    public void initialize(String successRename, boolean directRename, String insufficientExp) {
        this.successRename = successRename;
        this.directRename = directRename;
        this.insufficientExp = insufficientExp;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SoundType getSoundOpen() {
        return this.soundOpen;
    }

    public void setSoundOpen(SoundType soundOpen) {
        this.soundOpen = soundOpen;
    }

    public List<String> getSlots() {
        return this.slots;
    }

    public void setSlots(List<String> slots) {
        this.slots = slots;
    }

    public Map<String, ItemConfig> getItemsConfig() {
        return this.itemsConfig;
    }

    public void setItemsConfig(Map<String, ItemConfig> itemsConfig) {
        this.itemsConfig = itemsConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getSizeModifiableSlot() {
        return this.sizeModifiableSlot;
    }

    public void setSizeModifiableSlot(int sizeModifiableSlot) {
        this.sizeModifiableSlot = sizeModifiableSlot;
    }

    public String getNameInterface() {
        return this.nameInterface;
    }

    public void setNameInterface(String nameInterface) {
        this.nameInterface = nameInterface;
    }

    public String getNameInterfaceToOpen() {
        return this.nameInterfaceToOpen;
    }

    public void setNameInterfaceToOpen(String nameInterfaceToOpen) {
        this.nameInterfaceToOpen = nameInterfaceToOpen;
    }

    public String getNameInterfaceToReturn() {
        return this.nameInterfaceToReturn;
    }

    public void setNameInterfaceToReturn(String nameInterfaceToReturn) {
        this.nameInterfaceToReturn = nameInterfaceToReturn;
    }

    public void removeInventory(String playerName, Inventory inventory, Location dropLocation, boolean removeOnly) {
        int enchantSlot;
        ItemStack enchantedBook;
        if (removeOnly) {
            this.anvilInventories.remove(playerName);
            return;
        }
        Interface customInterface = Main.instance.getConfigGestion().getInterfaces().get("Anvil");
        Player player = Bukkit.getPlayer((String)playerName);
        int itemSlot = customInterface.getImportantSlots().get("FirstItem");
        ItemStack item = inventory.getItem(itemSlot);
        if (item != null) {
            if (player != null && player.getInventory().firstEmpty() != -1) {
                player.getInventory().addItem(new ItemStack[]{item});
            } else {
                dropLocation.getWorld().dropItem(dropLocation, item);
            }
        }
        if ((enchantedBook = inventory.getItem(enchantSlot = customInterface.getImportantSlots().get("SecondItem").intValue())) != null && enchantedBook.getType() != Material.PAPER) {
            if (player != null && player.getInventory().firstEmpty() != -1) {
                player.getInventory().addItem(new ItemStack[]{enchantedBook});
            } else {
                dropLocation.getWorld().dropItem(dropLocation, enchantedBook);
            }
        }
        this.anvilInventories.remove(playerName);
    }

    public InventoryView getInventoryFromName(String playerName) {
        return this.anvilInventories.get(playerName);
    }

    public Map<String, Integer> getImportantSlots() {
        return this.importantSlots;
    }

    public void closeAllInventories() {
        for (Map.Entry<String, InventoryView> inventory : this.anvilInventories.entrySet()) {
            Player player = Bukkit.getPlayer((String)inventory.getKey());
            if (player == null) continue;
            Inventory topInventory = player.getOpenInventory().getTopInventory();
            if (topInventory.getHolder() instanceof CustomAnvilGUIHolder) {
                this.removeInventory(player.getName(), topInventory, player.getLocation(), false);
            }
            player.closeInventory();
        }
    }

    public boolean openInterface(Player player, InventoryView anvil) {
        if (Main.instance.getConfigGestion().isOnlyBedrock() && !Main.floodgateUtils.isBedrockPlayer(player.getUniqueId())) {
            return false;
        }
        this.anvilInventories.put(player.getName(), anvil);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
            Inventory customAnvilInventory = this.getCustomAnvilInventory(player);
            player.openInventory(customAnvilInventory);
            this.soundOpen.playSound(player);
        });
        return true;
    }

    public void openInterface(Player player, PlayerWriteEvent event) {
        if (!Main.floodgateUtils.isBedrockPlayer(player.getUniqueId())) {
            return;
        }
        this.soundOpen.playSound(player);
        Main.floodgateUtils.getBedrockPlayer(player.getUniqueId()).sendForm(this.createCustomForm(player, event).build());
    }

    private CustomForm.Builder createCustomForm(Player player, PlayerWriteEvent event) {
        CustomForm.Builder customForm = (CustomForm.Builder)CustomForm.builder().title(this.title);
        for (FloodgateInput floodgateInput : this.floodgateInputs) {
            switch (floodgateInput.getType()) {
                case "Input": {
                    customForm.input(floodgateInput.getLabel(), floodgateInput.getPlaceholder());
                    break;
                }
                case "Button": {
                    break;
                }
            }
        }
        ((CustomForm.Builder)((CustomForm.Builder)customForm.validResultHandler(response -> {
            if (this.directRename) {
                int experienceRaw = ExpUtils.getExp(player);
                double levels = ExpUtils.getLevelFromExp(experienceRaw);
                if (levels >= 1.0) {
                    ItemStack itemInHand = event.getItemInHand(player.getName());
                    player.getInventory().remove(itemInHand);
                    ItemMeta itemMeta = itemInHand.getItemMeta();
                    itemMeta.setItemName(response.asInput(0));
                    itemInHand.setItemMeta(itemMeta);
                    player.getInventory().addItem(new ItemStack[]{itemInHand});
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> GuiEvent.damageAnvil(player, event.getAnvilLocation(), event.getInv()));
                    ExpUtils.changeExpLevels(player, -1);
                } else {
                    MessageGesture.sendMessage((CommandSender)player, this.insufficientExp);
                }
                event.removePlayer(player.getName());
            } else {
                event.addPlayer(player.getName(), event.getItemInHand(player.getName()), event.createItemStack(response.asInput(0)));
                MessageGesture.sendMessage((CommandSender)player, this.successRename);
            }
        })).closedResultHandler(() -> event.removePlayer(player.getName()))).invalidResultHandler(() -> event.removePlayer(player.getName()));
        return customForm;
    }

    public void setCostOfEnchant(Inventory inventory, int levels) {
        int slotToChange = this.importantSlots.get("Cost");
        inventory.setItem(slotToChange, this.getItemsConfig().get(this.importantSlotsLetter.get("Cost")).createItemConfig(this.getNameInterface(), "ap.experience:" + levels, slotToChange));
    }

    public void setBorder(Inventory inventory, int slot) {
        inventory.setItem(slot, this.itemsConfig.get(this.importantSlotsLetter.get("Border")).createItemConfig(this.getNameInterface(), "", slot));
    }

    public void deleteItemsWhenResult(Inventory inventory) {
        int slotToChange = this.importantSlots.get("FirstItem");
        inventory.setItem(slotToChange, null);
        slotToChange = this.importantSlots.get("SecondItem");
        inventory.setItem(slotToChange, null);
    }

    public void deleteResult(Inventory inventory) {
        int slotCost = this.importantSlots.get("Cost");
        this.setBorder(inventory, slotCost);
        this.setBarrier(inventory, " ");
    }

    public void setBarrier(Inventory inventory, String reason) {
        int slotResult = this.importantSlots.get("NoResult");
        inventory.setItem(slotResult, this.getItemsConfig().get(this.importantSlotsLetter.get("NoResult")).createItemConfig(this.getNameInterface(), "ap.message:" + reason, slotResult));
    }

    public void setRename(Inventory inventory, Player player, PlayerWriteEvent event, ItemStack itemToRename) {
        int slotToChange = this.importantSlots.get("FirstItem");
        inventory.setItem(slotToChange, itemToRename);
        slotToChange = this.importantSlots.get("SecondItem");
        inventory.setItem(slotToChange, event.getItemWithPlayerName(player.getName()));
    }

    private Inventory getCustomAnvilInventory(Player player) {
        CustomAnvilGUIHolder holder = new CustomAnvilGUIHolder(this.getSlots().size(), this.getTitle());
        Inventory inventory = holder.getInventory();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            block0: for (int i = 0; i < this.getSlots().size(); ++i) {
                String slot = this.getSlots().get(i);
                if (this.getItemsConfig().get(slot) == null) continue;
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("FirstItem")) {
                    this.importantSlots.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), i);
                    this.importantSlotsLetter.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), slot);
                    continue;
                }
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("SecondItem")) {
                    this.importantSlots.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), i);
                    this.importantSlotsLetter.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), slot);
                    continue;
                }
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("NoResult")) {
                    this.importantSlots.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), i);
                    this.importantSlotsLetter.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), slot);
                    inventory.setItem(i, this.getItemsConfig().get(slot).createItemConfig(this.getNameInterface(), "ap.message: ", i));
                    continue;
                }
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("Fix")) {
                    inventory.setItem(i, this.getItemsConfig().get(slot).createItemConfig(this.getNameInterface(), "ap.priceHand:" + Main.instance.getConfigGestion().getFixHandPayment().calculatePrice(player, true) + ";ap.priceInventory:" + Main.instance.getConfigGestion().getFixHandPayment().calculatePrice(player, false), i));
                    continue;
                }
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("Cost")) {
                    this.importantSlots.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), i);
                    this.importantSlotsLetter.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), slot);
                    for (Map.Entry<String, ItemConfig> itemConfig : this.itemsConfig.entrySet()) {
                        if (!itemConfig.getValue().getNameItemConfig().equalsIgnoreCase("Border")) continue;
                        inventory.setItem(i, itemConfig.getValue().createItemConfig(this.getNameInterface(), "", i));
                        continue block0;
                    }
                    continue;
                }
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("Back")) {
                    if (!Main.floodgateUtils.isBedrockPlayer(player.getUniqueId())) {
                        this.importantSlotsLetter.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), slot);
                        inventory.setItem(i, this.getItemsConfig().get(slot).createItemConfig(this.getNameInterface(), "", i));
                        continue;
                    }
                    for (Map.Entry<String, ItemConfig> itemConfig : this.itemsConfig.entrySet()) {
                        if (!itemConfig.getValue().getNameItemConfig().equalsIgnoreCase("Border")) continue;
                        inventory.setItem(i, itemConfig.getValue().createItemConfig(this.getNameInterface(), "", i));
                        continue block0;
                    }
                    continue;
                }
                this.importantSlotsLetter.putIfAbsent(this.itemsConfig.get(slot).getNameItemConfig(), slot);
                inventory.setItem(i, this.getItemsConfig().get(slot).createItemConfig(this.getNameInterface(), "", i));
            }
        });
        return inventory;
    }
}

