/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.CustomAnvilGUI.Interfaces;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.HeroxWar.HeroxCore.Utils.Texture;
import com.HeroxWar.HeroxCore.Utils.TextureException;
import com.heroxplugins.external.CustomAnvilGUI.de.tr7zw.NBTItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemConfig {
    private String name;
    private String type;
    private String texture;
    private String soundClick;
    private String nameItemConfig;
    private List<String> lore;

    public ItemConfig(String nameItemConfig, String name, String type, String texture, List<String> lore, String soundClick) {
        this.name = name;
        this.type = type;
        this.texture = texture;
        this.lore = lore;
        this.soundClick = soundClick;
        this.nameItemConfig = nameItemConfig;
    }

    public ItemStack createItemConfig(String currentInterface, String nbt, int positionItem) {
        String[] nbtSplit;
        ItemStack item;
        String[] nbtList = new String[]{};
        if (!nbt.equalsIgnoreCase("")) {
            nbtList = nbt.split(";");
        }
        if (!this.type.contains(";")) {
            item = new ItemStack(Material.getMaterial((String)this.type));
        } else {
            String[] x = this.type.split(";");
            item = new ItemStack(Material.getMaterial((String)x[0]), 1, Short.parseShort(x[1]));
        }
        if ((this.type.equalsIgnoreCase("PLAYER_HEAD") || this.type.contains("SKULL")) && !this.texture.equalsIgnoreCase("")) {
            try {
                Texture.setCustomTexture(item, this.texture);
            }
            catch (TextureException e) {
                throw new RuntimeException(e);
            }
        }
        ItemMeta itemm = item.getItemMeta();
        if (!this.lore.isEmpty()) {
            ArrayList<String> lorenew = new ArrayList<String>();
            for (String lorePart : this.lore) {
                lorenew.add(MessageGesture.transformColor(lorePart).replace("{priceHand}", nbtList[0].split(":")[1]).replace("{priceInventory}", nbtList[1].split(":")[1]));
            }
            itemm.setLore(lorenew);
        }
        String newName = this.name;
        if (this.name.contains("{exp}")) {
            String cost = "";
            for (String nbtString : nbtList) {
                nbtSplit = nbtString.split(":");
                if (!nbtSplit[0].equalsIgnoreCase("ap.experience")) continue;
                cost = nbtSplit[1];
                break;
            }
            newName = this.name.replace("{exp}", cost);
        } else if (this.name.contains("{message}")) {
            String message = "";
            for (String nbtString : nbtList) {
                nbtSplit = nbtString.split(":");
                if (!nbtSplit[0].equalsIgnoreCase("ap.message")) continue;
                message = nbtSplit[1];
                break;
            }
            newName = this.name.replace("{message}", message);
        }
        itemm.setDisplayName(MessageGesture.transformColor(newName));
        item.setItemMeta(itemm);
        if (item.getType().toString().equalsIgnoreCase("AIR")) {
            return item;
        }
        NBTItem nbtItem = new NBTItem(item);
        for (String nbtString : nbtList) {
            nbtSplit = nbtString.split(":");
            try {
                int numberPage = Integer.parseInt(nbtSplit[1]);
                nbtItem.setInteger(nbtSplit[0], numberPage);
            }
            catch (Exception ex) {
                nbtItem.setString(nbtSplit[0], nbtSplit[1]);
            }
        }
        nbtItem.setInteger("ap.positionItem", positionItem);
        nbtItem.setString("ap.currentInterface", currentInterface);
        return nbtItem.getItem();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTexture() {
        return this.texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(ArrayList<String> lore) {
        this.lore = lore;
    }

    public String getSoundClick() {
        return this.soundClick;
    }

    public void setSoundClick(String soundClick) {
        this.soundClick = soundClick;
    }

    public String getNameItemConfig() {
        return this.nameItemConfig;
    }

    public void setNameItemConfig(String nameItemConfig) {
        this.nameItemConfig = nameItemConfig;
    }

    public String toString() {
        return "ItemConfig{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", texture='" + this.texture + '\'' + ", soundClick='" + this.soundClick + '\'' + ", nameItemConfig='" + this.nameItemConfig + '\'' + ", lore=" + this.lore + '}';
    }
}

