/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.CustomAnvilGUI.Utils;

import io.eliotesta98.CustomAnvilGUI.Core.Main;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.Bukkit;

public final class Library {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String jarPath;

    private Library(String groupId, String artifactId, String version, String repositoryPath) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.jarPath = repositoryPath;
    }

    public boolean load() {
        try {
            URL url;
            File libraries = new File(Bukkit.getWorldContainer(), "libraries");
            File file = new File(libraries, this.groupId.replace(".", "/") + "/" + this.artifactId.replace(".", "/") + "/" + this.version + "/" + this.artifactId + "-" + this.version + ".jar");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                Bukkit.getLogger().info("Downloading library: " + this.getName());
                url = new URL(this.jarPath);
                URLConnection connection = url.openConnection();
                try (InputStream in = connection.getInputStream();){
                    Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            url = file.toURI().toURL();
            ClassLoader classLoader = Main.class.getClassLoader();
            Method method = Library.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            Library.invoke(method, classLoader, url);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load library " + this.getName() + ".", throwable);
        }
        return true;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... args) throws Exception {
        Class<?> originalClass = clazz;
        while (!clazz.equals(Object.class)) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, args);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException ex) {
                clazz = clazz.getSuperclass();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new Exception("Error import library");
            }
        }
        throw new Exception("Unable to find method " + methodName + " in class " + originalClass + " and her subclasses");
    }

    public static <T> T invoke(Method method, Object instance, Object ... params) throws Exception {
        try {
            return (T)method.invoke(instance, params);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            throw new Exception("Could not invoke method " + method + " on instance " + instance);
        }
    }

    public String getName() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toString() {
        return this.getName();
    }

    public static Library fromMavenRepo(String path) {
        String[] split = path.split("\\:");
        return Library.fromMavenRepo(split[0], split[1], split[2]);
    }

    public static Library fromMavenRepo(String groupId, String artifactId, String version) {
        String jarPath = "https://repo1.maven.org/maven2/" + groupId.replace(".", "/") + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".jar";
        return new Library(groupId, artifactId, version, jarPath);
    }

    public static Library fromPath(String groupId, String artifactId, String version, String jarPath) {
        return new Library(groupId, artifactId, version, jarPath);
    }
}

