/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.peaceful_hunger.impl.common.network.packet;

import com.cursee.peaceful_hunger.impl.client.network.packet.ConfigSyncClientHandler;
import com.cursee.peaceful_hunger.impl.common.config.PeacefulHungerConfig;
import com.cursee.peaceful_hunger.platform.Services;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ConfigSyncS2CPacket {
    private Difficulty hungerDifficulty;
    private boolean naturalRegenAllowedInPeaceful;

    public ConfigSyncS2CPacket(Difficulty hungerDifficulty, boolean naturalRegenAllowedInPeaceful) {
        this.hungerDifficulty = hungerDifficulty;
        this.naturalRegenAllowedInPeaceful = naturalRegenAllowedInPeaceful;
    }

    public void write(FriendlyByteBuf data) {
        data.m_130130_(this.hungerDifficulty.m_19028_());
        data.writeBoolean(this.naturalRegenAllowedInPeaceful);
    }

    public Difficulty getHungerDifficulty() {
        return this.hungerDifficulty;
    }

    public boolean isNaturalRegenAllowedInPeaceful() {
        return this.naturalRegenAllowedInPeaceful;
    }

    public static ConfigSyncS2CPacket read(FriendlyByteBuf data) {
        return new ConfigSyncS2CPacket(Difficulty.m_19029_((int)data.m_130242_()), data.readBoolean());
    }

    public static void createAndSend(Entity entity, Level level) {
        ServerPlayer serverPlayer;
        block3: {
            block2: {
                if (!(entity instanceof ServerPlayer)) break block2;
                serverPlayer = (ServerPlayer)entity;
                if (level instanceof ServerLevel) break block3;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Services.PLATFORM.sendToPlayer(serverPlayer, new ConfigSyncS2CPacket(PeacefulHungerConfig.getInstance().getHungerDifficulty(), PeacefulHungerConfig.getInstance().isNaturalRegenAllowedInPeaceful()));
    }

    public void handle() {
        ConfigSyncClientHandler.handle(this);
    }
}

