/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.peaceful_hunger.mixin;

import com.cursee.peaceful_hunger.impl.common.config.PeacefulHungerConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(method={"tickRegeneration"}, at={@At(value="HEAD")}, cancellable=true)
    private void peaceful_hunger$tick$getNaturalRegeneration(CallbackInfo ci) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        ServerLevel serverlevel = serverPlayer.level();
        boolean allowedByGameRule = serverlevel.getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION);
        boolean naturalRegenAllowedInPeaceful = PeacefulHungerConfig.getInstance().isNaturalRegenAllowedInPeaceful();
        if (!naturalRegenAllowedInPeaceful && allowedByGameRule && PeacefulHungerConfig.getInstance().getHungerDifficulty() != Difficulty.PEACEFUL) {
            ci.cancel();
        }
    }
}

