/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.peaceful_hunger.impl.common.config;

import com.cursee.peaceful_hunger.impl.common.config.SimpleConfig;
import com.cursee.peaceful_hunger.platform.Services;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1267;

public class PeacefulHungerConfig {
    public static final String LOG_PREFIX = "[Peaceful Hunger] ";
    private static PeacefulHungerConfig instance = null;
    private class_1267 hungerDifficulty = class_1267.field_5807;
    private boolean naturalRegenAllowedInPeaceful = false;

    public static PeacefulHungerConfig getInstance() {
        return instance;
    }

    public class_1267 getHungerDifficulty() {
        return this.hungerDifficulty;
    }

    public void setHungerDifficulty(class_1267 hungerDifficulty) {
        this.hungerDifficulty = hungerDifficulty;
    }

    public boolean isNaturalRegenAllowedInPeaceful() {
        return this.naturalRegenAllowedInPeaceful;
    }

    public void setNaturalRegenAllowedInPeaceful(boolean naturalRegenAllowedInPeaceful) {
        this.naturalRegenAllowedInPeaceful = naturalRegenAllowedInPeaceful;
    }

    public void onLoad() {
        if (instance == null) {
            instance = this;
        }
        this.createOrLoadConfiguration();
    }

    public void createOrLoadConfiguration() {
        String configDirectoryPathString = String.valueOf(Services.PLATFORM.getGameDirectory()) + File.separator + "config";
        File configDirectory = new File(configDirectoryPathString);
        if (!configDirectory.isDirectory() && !configDirectory.mkdirs()) {
            System.out.println("[Peaceful Hunger] Failed to create config directory, Faster Happy Ghasts retaining default values.");
            return;
        }
        String configFileNameString = "peaceful_hunger-common.toml";
        String configFilePathString = configDirectoryPathString + File.separator + configFileNameString;
        File configFile = new File(configFilePathString);
        if (!configFile.exists()) {
            try (InputStream inputStream = PeacefulHungerConfig.class.getClassLoader().getResourceAsStream("assets/" + configFileNameString);){
                if (inputStream == null) {
                    System.out.println("[Peaceful Hunger] Failed to initialize InputStream instance for assets/" + configFileNameString);
                    return;
                }
                try (BufferedInputStream bis = new BufferedInputStream(inputStream);
                     BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(configFile));){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        bos.write(buffer, 0, bytesRead);
                    }
                }
                System.out.println("[Peaceful Hunger] Created new configuration file: " + configFilePathString);
            }
            catch (IOException e) {
                System.out.println("[Peaceful Hunger] Failed to read internal resource: assets/" + configFileNameString);
                System.out.println(LOG_PREFIX + e.getMessage());
            }
        } else {
            System.out.println("[Peaceful Hunger] Reading configuration file: " + configFilePathString);
            try {
                SimpleConfig config = new SimpleConfig(configFilePathString);
                int internalDifficulty = config.getInteger("hunger_difficulty", 3);
                switch (internalDifficulty) {
                    case 0: {
                        this.hungerDifficulty = class_1267.field_5801;
                        break;
                    }
                    case 1: {
                        this.hungerDifficulty = class_1267.field_5805;
                        break;
                    }
                    case 2: {
                        this.hungerDifficulty = class_1267.field_5802;
                        break;
                    }
                    case 3: {
                        this.hungerDifficulty = class_1267.field_5807;
                        break;
                    }
                    default: {
                        System.out.println("[Peaceful Hunger] Failed to read difficulty, using default value.");
                    }
                }
                this.naturalRegenAllowedInPeaceful = config.getBoolean("natural_regen_in_peaceful", false);
            }
            catch (IOException ignored) {
                System.out.println("[Peaceful Hunger] Failed to read " + configFilePathString + ", retaining default config values");
            }
            System.out.println("[Peaceful Hunger] Difficulty for hunger checks was set to " + this.hungerDifficulty.name());
        }
    }
}

