/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.rearm.CompatFlags;
import me.pajic.rearm.Main;
import me.pajic.rearm.ability.CripplingThrowAbility;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Shadow
    public abstract int getUseDuration(ItemStack var1, LivingEntity var2);

    @WrapMethod(method={"getUseDuration"})
    private int axe_useDuration(ItemStack stack, LivingEntity entity, Operation<Integer> original) {
        if (((Boolean)Main.CONFIG.axe.cripplingThrow.get()).booleanValue() && stack.is(ItemTags.AXES)) {
            return 72000;
        }
        return (Integer)original.call(new Object[]{stack, entity});
    }

    @WrapMethod(method={"getUseAnimation"})
    private UseAnim axe_useAnimaton(ItemStack stack, Operation<UseAnim> original) {
        if (((Boolean)Main.CONFIG.axe.cripplingThrow.get()).booleanValue() && stack.is(ItemTags.AXES)) {
            if (CompatFlags.HMI_LOADED) {
                return UseAnim.NONE;
            }
            return UseAnim.SPEAR;
        }
        return (UseAnim)original.call(new Object[]{stack});
    }

    @WrapMethod(method={"use"})
    private InteractionResultHolder<ItemStack> axe_use(Level level, Player player, InteractionHand usedHand, Operation<InteractionResultHolder<ItemStack>> original) {
        ItemStack stack;
        if (((Boolean)Main.CONFIG.axe.cripplingThrow.get()).booleanValue() && (stack = player.getItemInHand(usedHand)).is(ItemTags.AXES)) {
            return CripplingThrowAbility.useAxe(level, player, usedHand, stack);
        }
        return (InteractionResultHolder)original.call(new Object[]{level, player, usedHand});
    }

    @WrapMethod(method={"releaseUsing"})
    private void axe_releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, Operation<Void> original) {
        if (((Boolean)Main.CONFIG.axe.cripplingThrow.get()).booleanValue() && stack.is(ItemTags.AXES)) {
            CripplingThrowAbility.throwAxe(stack, level, livingEntity, timeCharged, this.getUseDuration(stack, livingEntity));
        } else {
            original.call(new Object[]{stack, level, livingEntity, timeCharged});
        }
    }
}

