/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.network;

import java.util.List;
import java.util.UUID;
import me.pajic.rearm.Main;
import me.pajic.rearm.ability.CooldownTracker;
import me.pajic.rearm.ability.CripplingThrowAbility;
import me.pajic.rearm.ability.CriticalCounterAbility;
import me.pajic.rearm.enchantment.ReArmEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class ReArmNetworking {
    public static final ResourceLocation BACKSTEP_EXHAUSTION = ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"backstep_exhaustion");
    public static final ResourceLocation COUNTER_START_TIMER = ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"counter_start_timer");
    public static final ResourceLocation UPDATE_PLAYER_COUNTER_CONDITION = ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"update_player_counter_condition");
    public static final ResourceLocation RECALL_AXE = ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"recall_axe");
    public static final ResourceLocation BASH_SIGNAL = ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"bash_signal");

    @SubscribeEvent
    public static void init(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(C2SCauseBackstepExhaustionPayload.TYPE, C2SCauseBackstepExhaustionPayload.CODEC, (payload, context) -> context.player().causeFoodExhaustion(payload.exhaustion));
        registrar.playToServer(C2SUpdatePlayerCounterCondition.TYPE, C2SUpdatePlayerCounterCondition.CODEC, (payload, context) -> CriticalCounterAbility.setPlayerCounterCondition(payload.activePlayerUUID(), payload.shouldCounter()));
        registrar.playToServer(C2SUpdatePlayerRecallCondition.TYPE, C2SUpdatePlayerRecallCondition.CODEC, (payload, context) -> CripplingThrowAbility.recallSignals.add(payload.activePlayerUUID));
        registrar.playToServer(C2SBashSignal.TYPE, C2SBashSignal.CODEC, (payload, context) -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            int bashLevel = player.getUseItem().getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(ReArmEnchantments.BASH));
            if (bashLevel > 0 && player.isBlocking()) {
                double bashRange = (Double)Main.CONFIG.shield.bashBaseRange.get() + (double)bashLevel * (Double)Main.CONFIG.shield.bashRangePerLevel.get();
                List<LivingEntity> targets = level.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(bashRange, 1.0, bashRange)).stream().filter(livingEntity -> livingEntity != player).toList();
                if (!targets.isEmpty()) {
                    targets.forEach(entity -> {
                        entity.knockback((Double)Main.CONFIG.shield.bashBaseKnockback.get() + (double)bashLevel * (Double)Main.CONFIG.shield.bashKnockbackPerLevel.get(), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                        entity.hurt(level.damageSources().playerAttack((Player)player), ((Float)Main.CONFIG.shield.bashBaseDamage.get()).floatValue() + 2.0f * ((Float)Main.CONFIG.shield.bashDamagePerLevel.get()).floatValue());
                        level.sendParticles((ParticleOptions)ParticleTypes.CRIT, entity.getX(), entity.getY() + 0.5, entity.getZ(), 8, 0.3, 0.3, 0.3, 0.2);
                    });
                    level.playSound(null, player.getOnPos(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 0.2f + level.random.nextFloat() * 0.3f);
                    level.registryAccess().registryOrThrow(Registries.ITEM).getTag(Main.SHIELDS).ifPresent(tag -> tag.forEach(item -> player.getCooldowns().addCooldown((Item)item.value(), (Integer)Main.CONFIG.shield.bashShieldCooldown.get() * 20)));
                    player.getUseItem().hurtAndBreak(targets.size(), (LivingEntity)player, player.getMainHandItem().is(player.getUseItem().getItem()) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    player.stopUsingItem();
                }
            }
        });
        registrar.playToClient(S2CStartCriticalCounterTimer.TYPE, S2CStartCriticalCounterTimer.CODEC, (payload, context) -> {
            CooldownTracker.counterTimerActive = true;
        });
    }

    public static void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record C2SCauseBackstepExhaustionPayload(float exhaustion) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SCauseBackstepExhaustionPayload> TYPE = new CustomPacketPayload.Type(BACKSTEP_EXHAUSTION);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SCauseBackstepExhaustionPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, C2SCauseBackstepExhaustionPayload::exhaustion, C2SCauseBackstepExhaustionPayload::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record C2SUpdatePlayerCounterCondition(UUID activePlayerUUID, boolean shouldCounter) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SUpdatePlayerCounterCondition> TYPE = new CustomPacketPayload.Type(UPDATE_PLAYER_COUNTER_CONDITION);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SUpdatePlayerCounterCondition> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2SUpdatePlayerCounterCondition::activePlayerUUID, (StreamCodec)ByteBufCodecs.BOOL, C2SUpdatePlayerCounterCondition::shouldCounter, C2SUpdatePlayerCounterCondition::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record C2SUpdatePlayerRecallCondition(UUID activePlayerUUID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SUpdatePlayerRecallCondition> TYPE = new CustomPacketPayload.Type(RECALL_AXE);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SUpdatePlayerRecallCondition> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2SUpdatePlayerRecallCondition::activePlayerUUID, C2SUpdatePlayerRecallCondition::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record C2SBashSignal() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SBashSignal> TYPE = new CustomPacketPayload.Type(BASH_SIGNAL);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SBashSignal> CODEC = StreamCodec.unit((Object)new C2SBashSignal());

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record S2CStartCriticalCounterTimer() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<S2CStartCriticalCounterTimer> TYPE = new CustomPacketPayload.Type(COUNTER_START_TIMER);
        public static final StreamCodec<RegistryFriendlyByteBuf, S2CStartCriticalCounterTimer> CODEC = StreamCodec.unit((Object)new S2CStartCriticalCounterTimer());

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

