/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.config;

import java.util.Map;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresAction;
import me.fzzyhmstrs.fzzy_config.annotations.Version;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedMap;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedString;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import me.pajic.rearm.ReArm;
import net.minecraft.resources.ResourceLocation;

@Version(version=1)
public class ModConfig
extends Config {
    public Bow bow = new Bow();
    public Crossbow crossbow = new Crossbow();
    public Sword sword = new Sword();
    public Axe axe = new Axe();
    public Shield shield = new Shield();
    public Armor armor = new Armor();
    public Protection protection = new Protection();
    public Tweaks tweaks = new Tweaks();

    public ModConfig() {
        super(ReArm.CONFIG_RL);
    }

    public static class Bow
    extends ConfigSection {
        public ValidatedBoolean enablePerfectShot = new ValidatedBoolean(true);
        public ValidatedInt perfectShotAdditionalDamage = new ValidatedInt(2, Integer.MAX_VALUE, 1);
        public ValidatedFloat perfectShotTimeframe = new ValidatedFloat(0.2f);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean enableBackstep = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedInt backstepTimeframe = new ValidatedInt(5, Integer.MAX_VALUE, 1);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean improvedMultishot = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedInt maxMultishotLevel = new ValidatedInt(3, Integer.MAX_VALUE, 1);
        @RequiresAction(action=Action.RESTART)
        public ValidatedInt additionalArrowsPerLevel = new ValidatedInt(1, Integer.MAX_VALUE, 1);
        public ValidatedBoolean playerDrawingSounds = new ValidatedBoolean(true);
        public ValidatedBoolean mobDrawingSounds = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean acceptMultishot = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean bowNetheriteVariant = new ValidatedBoolean(true);
    }

    public static class Crossbow
    extends ConfigSection {
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean improvedPiercing = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedInt percentArmorIgnoredPerLevel = new ValidatedInt(15, Integer.MAX_VALUE, 1);
        public ValidatedBoolean stopPiercingOnArmoredEntity = new ValidatedBoolean(true);
        public ValidatedBoolean fixedArrowDamage = new ValidatedBoolean(true);
        public ValidatedInt fixedArrowDamageAmount = new ValidatedInt(10, Integer.MAX_VALUE, 1);
        public ValidatedBoolean modifyFireworkDamage = new ValidatedBoolean(true);
        public ValidatedInt baseFireworkDamage = new ValidatedInt(12, Integer.MAX_VALUE, 1);
        public ValidatedInt damagePerFireworkStar = new ValidatedInt(3, Integer.MAX_VALUE, 0);
        public ValidatedBoolean modifyLoadSpeed = new ValidatedBoolean(true);
        public ValidatedFloat loadTime = new ValidatedFloat(2.0f);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean rejectMultishot = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean acceptPower = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean acceptInfinity = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean crossbowNetheriteVariant = new ValidatedBoolean(true);
    }

    public static class Sword
    extends ConfigSection {
        public ValidatedBoolean enableCriticalCounter = new ValidatedBoolean(true);
        public ValidatedInt criticalCounterTimeframe = new ValidatedInt(10, Integer.MAX_VALUE, 1);
        public ValidatedBoolean disableVanillaCrits = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean improvedSweepingEdge = new ValidatedBoolean(true);
        public ValidatedFloat sweepingEdgeAdditionalDamagePerMob = new ValidatedFloat(1.0f);
        public ValidatedInt maxMobAmountUsedForDamageIncrease = new ValidatedInt(10, Integer.MAX_VALUE, 1);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean rejectKnockback = new ValidatedBoolean(true);
    }

    public static class Axe
    extends ConfigSection {
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean cripplingThrow = new ValidatedBoolean(true);
        public ValidatedInt cripplingThrowBleedingDuration = new ValidatedInt(120, Integer.MAX_VALUE, 1);
        public ValidatedFloat cripplingThrowBaseBleedingDPS = new ValidatedFloat(1.0f);
        public ValidatedFloat cripplingThrowBleedingDPSIncreasePerLevel = new ValidatedFloat(0.5f);
        public ValidatedInt cripplingThrowBaseSlownessAmplifier = new ValidatedInt(1, Integer.MAX_VALUE, 1);
        public ValidatedInt cripplingThrowSlownessAmplifierIncreasePerLevel = new ValidatedInt(1, Integer.MAX_VALUE, 1);
        public ValidatedInt maxTimeStuckInTarget = new ValidatedInt(240, Integer.MAX_VALUE, 1);
        public ValidatedBoolean enableCriticalCounter = new ValidatedBoolean(false);
        public ValidatedBoolean disableVanillaCrits = new ValidatedBoolean(false);
        public ValidatedBoolean acceptKnockback = new ValidatedBoolean(true);
        public ValidatedBoolean acceptLooting = new ValidatedBoolean(true);
    }

    public static class Shield
    extends ConfigSection {
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean enableBash = new ValidatedBoolean(true);
        public ValidatedInt bashShieldCooldown = new ValidatedInt(8, Integer.MAX_VALUE, 1);
        public ValidatedFloat bashBaseDamage = new ValidatedFloat(0.0f, Float.MAX_VALUE, 0.0f);
        public ValidatedFloat bashDamagePerLevel = new ValidatedFloat(2.0f, Float.MAX_VALUE, 0.0f);
        public ValidatedDouble bashBaseRange = new ValidatedDouble(1.5, Double.MAX_VALUE, 0.0);
        public ValidatedDouble bashRangePerLevel = new ValidatedDouble(0.5, Double.MAX_VALUE, 0.0);
        public ValidatedDouble bashBaseKnockback = new ValidatedDouble(0.75, Double.MAX_VALUE, 0.0);
        public ValidatedDouble bashKnockbackPerLevel = new ValidatedDouble(0.75, Double.MAX_VALUE, 0.0);
        public ValidatedBoolean enableParry = new ValidatedBoolean(true);
        public ValidatedInt parryTimeframe = new ValidatedInt(5, Integer.MAX_VALUE, 1);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean shieldNetheriteVariant = new ValidatedBoolean(true);
    }

    @RequiresAction(action=Action.RESTART)
    public static class Armor
    extends ConfigSection {
        public ValidatedBoolean armorRebalance = new ValidatedBoolean(true);
        public ValidatedFloat armorMultiplier = new ValidatedFloat(2.0f, Float.MAX_VALUE, 1.0f);
        public ValidatedInt helmetArmorPercent = new ValidatedInt(20, 100, 0);
        public ValidatedInt chestplateArmorPercent = new ValidatedInt(35, 100, 0);
        public ValidatedInt leggingsArmorPercent = new ValidatedInt(30, 100, 0);
        public ValidatedInt bootsArmorPercent = new ValidatedInt(15, 100, 0);
        public ValidatedInt bodyArmorPercent = new ValidatedInt(80, 100, 0);
        public ValidatedMap<ResourceLocation, Integer> totalArmorOverrides = new ValidatedMap.Builder().keyHandler((Entry)new ValidatedIdentifier()).valueHandler((Entry)new ValidatedInt(0, (int)(20.0f * ((Float)this.armorMultiplier.get()).floatValue()), 0)).defaults(Map.of(ResourceLocation.withDefaultNamespace((String)"leather"), 8, ResourceLocation.withDefaultNamespace((String)"copper"), 16, ResourceLocation.withDefaultNamespace((String)"gold"), 16, ResourceLocation.withDefaultNamespace((String)"iron"), 24, ResourceLocation.withDefaultNamespace((String)"chainmail"), 24, ResourceLocation.withDefaultNamespace((String)"diamond"), 32, ResourceLocation.withDefaultNamespace((String)"netherite"), 40, ResourceLocation.withDefaultNamespace((String)"turtle_scute"), 24, ResourceLocation.withDefaultNamespace((String)"armadillo_scute"), 40)).build();
        public ValidatedBoolean enchantmentBasedToughness = new ValidatedBoolean(true);
        public ValidatedMap<String, Float> toughnessPerEnchantment = new ValidatedMap.Builder().keyHandler((Entry)new ValidatedString()).valueHandler((Entry)new ValidatedFloat(0.0f, 1.0f, 0.0f)).defaults(Map.of("blast_protection", Float.valueOf(0.8f), "protection", Float.valueOf(0.3f), "projectile_protection", Float.valueOf(0.3f), "fire_protection", Float.valueOf(0.1f), "magic_protection", Float.valueOf(0.8f))).build();
        public ValidatedBoolean defenseBasedKnockbackResist = new ValidatedBoolean(true);
    }

    public static class Protection
    extends ConfigSection {
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean meleeProtection = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean elementalProtection = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean magicProtection = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean normalizeEnchantmentCosts = new ValidatedBoolean(true);
        public ValidatedBoolean allowMultipleProtectionEnchantments = new ValidatedBoolean(true);
        public ValidatedInt maxProtectionEnchantments = new ValidatedInt(2, Integer.MAX_VALUE, 1);
    }

    public static class Tweaks
    extends ConfigSection {
        public ValidatedBoolean improvedSneaking = new ValidatedBoolean(true);
        public ValidatedInt detectionRangeReduction = new ValidatedInt(80, 100, 0);
        public ValidatedBoolean infinityFix = new ValidatedBoolean(true);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean infinimending = new ValidatedBoolean(false);
        @RequiresAction(action=Action.RESTART)
        public ValidatedBoolean craftTippedArrowsWithRegularPotions = new ValidatedBoolean(true);
    }
}

