/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import java.util.function.BiConsumer;
import me.pajic.rearm.ReArm;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract ItemEnchantments getEnchantments();

    @ModifyExpressionValue(method={"addModifierTooltip"}, at={@At(value="INVOKE", target="Ljava/text/DecimalFormat;format(D)Ljava/lang/String;", ordinal=1)})
    private String changeKnockbackResistDisplayStyle(String original, @Local(argsOnly=true) Holder<Attribute> attribute, @Local(ordinal=0) double d) {
        return attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d * 100.0) + "%" : original;
    }

    @ModifyReceiver(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/ItemAttributeModifiers;forEach(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V")})
    private ItemAttributeModifiers addToughness(ItemAttributeModifiers instance, EquipmentSlot equipmentSlot, BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        return this.rearm$addToughness(instance);
    }

    @ModifyReceiver(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/ItemAttributeModifiers;forEach(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V")})
    private ItemAttributeModifiers addToughness(ItemAttributeModifiers instance, EquipmentSlotGroup slotGroup, BiConsumer action) {
        return this.rearm$addToughness(instance);
    }

    @Unique
    private ItemAttributeModifiers rearm$addToughness(ItemAttributeModifiers instance) {
        ItemStack self;
        Item item;
        if (((Boolean)ReArm.CONFIG.armor.armorRebalance.get()).booleanValue() && ((Boolean)ReArm.CONFIG.armor.enchantmentBasedToughness.get()).booleanValue() && (item = (self = (ItemStack)this).getItem()) instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            double toughness = 0.0;
            for (Holder holder : this.getEnchantments().keySet()) {
                String enchantment = holder.getRegisteredName().split(":")[1];
                if (!((Map)ReArm.CONFIG.armor.toughnessPerEnchantment.get()).containsKey(enchantment)) continue;
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)self);
                toughness += (double)(((Float)((Map)ReArm.CONFIG.armor.toughnessPerEnchantment.get()).get(enchantment)).floatValue() * (float)level);
            }
            return instance.withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + armor.getType().getName())), toughness, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)armor.getType().getSlot()));
        }
        return instance;
    }
}

