/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import me.pajic.rearm.ReArm;
import me.pajic.rearm.ability.CriticalCounterAbility;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={Player.class}, priority=250)
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyArgs(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getSweepHitBox(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/AABB;"))
    private void sweepingEdge_increaseAttackRadius(Args args) {
        int sweepingEdgeLevel;
        if (((Boolean)ReArm.CONFIG.sword.improvedSweepingEdge.get()).booleanValue() && (sweepingEdgeLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SWEEPING_EDGE), (ItemStack)this.getWeaponItem())) > 0) {
            args.set(0, (Object)((Double)args.get(0) * (double)sweepingEdgeLevel));
            args.set(2, (Object)((Double)args.get(2) * (double)sweepingEdgeLevel));
            if (sweepingEdgeLevel >= 3) {
                args.set(1, (Object)1.0);
            }
        }
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private <T extends Entity> List<T> sweepingEdge_getHitEntities(List<T> original, @Share(value="original") LocalRef<List<T>> hitEntityList) {
        if (((Boolean)ReArm.CONFIG.sword.improvedSweepingEdge.get()).booleanValue()) {
            hitEntityList.set(original);
        }
        return original;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"), index=1)
    private <T extends Entity> float sweepingEdge_increaseDamage(float damage, @Share(value="original") LocalRef<List<T>> hitEntityList, @Local(ordinal=2) float h) {
        if (((Boolean)ReArm.CONFIG.sword.improvedSweepingEdge.get()).booleanValue()) {
            float additionalDamage = ((Float)ReArm.CONFIG.sword.sweepingEdgeAdditionalDamagePerMob.get()).floatValue() * (float)Math.min(((List)hitEntityList.get()).size() - 1, (Integer)ReArm.CONFIG.sword.maxMobAmountUsedForDamageIncrease.get());
            return damage + additionalDamage * h;
        }
        return damage;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=2)
    private boolean criticalCounter_critOnlyIfCriticalCounter(boolean original) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (CriticalCounterAbility.canCounter(this.getWeaponItem())) {
                return CriticalCounterAbility.getPlayerCounterCondition(serverPlayer.getUUID()) || CriticalCounterAbility.canVanillaCrit(this.getWeaponItem()) && original;
            }
        }
        return original;
    }

    @WrapMethod(method={"hurtCurrentlyUsedShield"})
    private void criticalCounter_startTimer(float damageAmount, Operation<Void> original) {
        Player player;
        original.call(new Object[]{Float.valueOf(damageAmount)});
        if (!this.useItem.isEmpty() && (player = (Player)this) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (CriticalCounterAbility.canCounter(this.getWeaponItem())) {
                ReArm.xplat().sendToClient(serverPlayer, new CriticalCounterAbility.S2CStartCriticalCounterTimer());
            }
        }
    }

    @ModifyExpressionValue(method={"getProjectile"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Abilities;instabuild:Z")})
    private boolean infinityFix(boolean original, @Local(argsOnly=true) ItemStack weaponStack) {
        if (((Boolean)ReArm.CONFIG.tweaks.infinityFix.get()).booleanValue()) {
            int infinityLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.INFINITY), (ItemStack)weaponStack);
            return original || infinityLevel > 0;
        }
        return original;
    }
}

